/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class MaxMetric
extends Metric {
    private long longMax = Long.MIN_VALUE;
    private double doubleMax = -1.7976931348623157E308;
    private String columnName;

    public MaxMetric(String columnName) {
        this.init("max", columnName);
    }

    public MaxMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (columnName == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName);
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public Number getValue() {
        if (this.longMax == Long.MIN_VALUE) {
            return this.doubleMax;
        }
        return this.longMax;
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public void update(Tuple tuple) {
        long l;
        Object o = tuple.get(this.columnName);
        if (o instanceof Double) {
            double d = (Double)o;
            if (d > this.doubleMax) {
                this.doubleMax = d;
            }
        } else if (o instanceof Float) {
            Float f = (Float)o;
            double d = f.doubleValue();
            if (d > this.doubleMax) {
                this.doubleMax = d;
            }
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            long l2 = i.longValue();
            if (l2 > this.longMax) {
                this.longMax = l2;
            }
        } else if (o instanceof Long && (l = ((Long)o).longValue()) > this.longMax) {
            this.longMax = l;
        }
    }

    @Override
    public Metric newInstance() {
        return new MaxMetric(this.columnName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

