/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamExpressionParser {
    static char[] wordChars = new char[]{'_', '.', '-'};

    static {
        Arrays.sort(wordChars);
    }

    public static StreamExpression parse(String clause) {
        StreamExpressionParameter expr = StreamExpressionParser.generateStreamExpression(clause = StreamExpressionParser.stripComments(clause));
        if (expr != null && expr instanceof StreamExpression) {
            return (StreamExpression)expr;
        }
        return null;
    }

    static String stripComments(String clause) throws RuntimeException {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new StringReader(clause));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    builder.append(line).append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    private static StreamExpressionParameter generateStreamExpression(String clause) {
        String working = clause.trim();
        if (!StreamExpressionParser.isExpressionClause(working)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper expression clause", working));
        }
        int firstOpenParen = StreamExpressionParser.findNextClear(working, 0, '(');
        StreamExpression expression = new StreamExpression(working.substring(0, firstOpenParen).trim());
        working = working.substring(firstOpenParen + 1, working.length() - 1).trim();
        List<String> parts = StreamExpressionParser.splitOn(working, ',');
        int idx = 0;
        while (idx < parts.size()) {
            String part = parts.get(idx).trim();
            if (StreamExpressionParser.isExpressionClause(part)) {
                parameter = StreamExpressionParser.generateStreamExpression(part);
                if (parameter != null) {
                    expression.addParameter(parameter);
                }
            } else if (StreamExpressionParser.isNamedParameterClause(part)) {
                parameter = StreamExpressionParser.generateNamedParameterExpression(part);
                if (parameter != null) {
                    expression.addParameter(parameter);
                }
            } else {
                expression.addParameter(new StreamExpressionValue(part));
            }
            ++idx;
        }
        return expression;
    }

    private static StreamExpressionNamedParameter generateNamedParameterExpression(String clause) {
        String working = clause.trim();
        if (!StreamExpressionParser.isNamedParameterClause(working)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
        }
        int firstOpenEquals = StreamExpressionParser.findNextClear(working, 0, '=');
        StreamExpressionNamedParameter namedParameter = new StreamExpressionNamedParameter(working.substring(0, firstOpenEquals).trim());
        String parameter = working.substring(firstOpenEquals + 1, working.length());
        if (StreamExpressionParser.isExpressionClause(parameter)) {
            namedParameter.setParameter(StreamExpressionParser.generateStreamExpression(parameter));
        } else {
            if (parameter.startsWith("\"") && parameter.endsWith("\"") && (parameter = parameter.substring(1, parameter.length() - 1).trim()).length() == 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
            }
            if (parameter.contains("\\\"") && (parameter = parameter.replace("\\\"", "\"")).length() == 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
            }
            if (parameter.contains("`") && (parameter = parameter.replace('`', '\"')).length() == 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
            }
            namedParameter.setParameter(new StreamExpressionValue(parameter));
        }
        return namedParameter;
    }

    private static boolean isExpressionClause(String clause) {
        if (!StreamExpressionParser.isBalanced(clause)) {
            return false;
        }
        int firstOpenParen = StreamExpressionParser.findNextClear(clause, 0, '(');
        if (firstOpenParen <= 0 || firstOpenParen == clause.length() - 1) {
            return false;
        }
        String functionName = clause.substring(0, firstOpenParen).trim();
        if (!StreamExpressionParser.wordToken(functionName)) {
            return false;
        }
        return clause.endsWith(")");
    }

    private static boolean isNamedParameterClause(String clause) {
        int firstOpenEquals = StreamExpressionParser.findNextClear(clause, 0, '=');
        if (firstOpenEquals <= 0 || firstOpenEquals == clause.length() - 1) {
            return false;
        }
        String name = clause.substring(0, firstOpenEquals);
        return StreamExpressionParser.wordToken(name.trim());
    }

    private static int findNextClear(String clause, int startingIdx, char findThis) {
        int openParens = 0;
        boolean isDoubleQuote = false;
        boolean isSingleQuote = false;
        boolean isEscaped = false;
        int idx = startingIdx;
        while (idx < clause.length()) {
            char c = clause.charAt(idx);
            if (!(c != findThis || isEscaped || isSingleQuote || isDoubleQuote || openParens != 0)) {
                return idx;
            }
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    break;
                }
                case '\"': {
                    if (!isEscaped && !isSingleQuote) {
                        isDoubleQuote = !isDoubleQuote;
                    }
                    isEscaped = false;
                    break;
                }
                case '\'': {
                    if (!isEscaped && !isDoubleQuote) {
                        isSingleQuote = !isSingleQuote;
                    }
                    isEscaped = false;
                    break;
                }
                case '(': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        ++openParens;
                    }
                    isEscaped = false;
                    break;
                }
                case ')': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        --openParens;
                    }
                    isEscaped = false;
                    break;
                }
                default: {
                    isEscaped = false;
                }
            }
            ++idx;
        }
        return -1;
    }

    private static List<String> splitOn(String clause, char splitOnThis) {
        String working = clause.trim();
        ArrayList<String> parts = new ArrayList<String>();
        while (true) {
            int nextIdx;
            if ((nextIdx = StreamExpressionParser.findNextClear(working, 0, splitOnThis)) < 0) {
                parts.add(working);
                break;
            }
            parts.add(working.substring(0, nextIdx));
            if (nextIdx + 1 == working.length()) break;
            working = working.substring(nextIdx + 1).trim();
        }
        return parts;
    }

    private static boolean isBalanced(String clause) {
        int openParens = 0;
        boolean isDoubleQuote = false;
        boolean isSingleQuote = false;
        boolean isEscaped = false;
        int idx = 0;
        while (idx < clause.length()) {
            char c = clause.charAt(idx);
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    break;
                }
                case '\"': {
                    if (!isEscaped && !isSingleQuote) {
                        isDoubleQuote = !isDoubleQuote;
                    }
                    isEscaped = false;
                    break;
                }
                case '\'': {
                    if (!isEscaped && !isDoubleQuote) {
                        isSingleQuote = !isSingleQuote;
                    }
                    isEscaped = false;
                    break;
                }
                case '(': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        ++openParens;
                    }
                    isEscaped = false;
                    break;
                }
                case ')': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote || --openParens >= 0)) {
                        return false;
                    }
                    isEscaped = false;
                    break;
                }
                default: {
                    isEscaped = false;
                }
            }
            ++idx;
        }
        return openParens == 0;
    }

    public static boolean wordToken(String token) {
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (!Character.isLetterOrDigit(c) && Arrays.binarySearch(wordChars, c) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

