/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamExpression
implements StreamExpressionParameter {
    private String functionName;
    private List<StreamExpressionParameter> parameters;

    public StreamExpression(String functionName) {
        this.functionName = functionName;
        this.parameters = new ArrayList<StreamExpressionParameter>();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException("Null functionName is not allowed.");
        }
        this.functionName = functionName;
    }

    public StreamExpression withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void addParameter(StreamExpressionParameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(String parameter) {
        this.addParameter(new StreamExpressionValue(parameter));
    }

    public StreamExpression withParameter(StreamExpressionParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public StreamExpression withParameter(String parameter) {
        return this.withParameter(new StreamExpressionValue(parameter));
    }

    public List<StreamExpressionParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<StreamExpressionParameter> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Null parameter list is not allowed.");
        }
        this.parameters = parameters;
    }

    public StreamExpression withParameters(List<StreamExpressionParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.functionName);
        sb.append("(");
        int idx = 0;
        while (idx < this.parameters.size()) {
            if (idx != 0) {
                sb.append(",");
            }
            sb.append(this.parameters.get(idx));
            ++idx;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other.getClass() != StreamExpression.class) {
            return false;
        }
        StreamExpression check = (StreamExpression)other;
        if (this.functionName == null && check.functionName != null) {
            return false;
        }
        if (this.functionName != null && check.functionName == null) {
            return false;
        }
        if (this.functionName != null && check.functionName != null && !this.functionName.equals(check.functionName)) {
            return false;
        }
        if (this.parameters.size() != check.parameters.size()) {
            return false;
        }
        int idx = 0;
        while (idx < this.parameters.size()) {
            StreamExpressionParameter right;
            StreamExpressionParameter left = this.parameters.get(idx);
            if (!left.equals(right = check.parameters.get(idx))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.functionName);
    }
}

