/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;

public class StreamExplanation
extends Explanation {
    private List<Explanation> children;

    public StreamExplanation(String expressionNodeId) {
        super(expressionNodeId);
    }

    public List<Explanation> getChildren() {
        return this.children;
    }

    public void setChildren(List<Explanation> children) {
        this.children = children;
    }

    public StreamExplanation withChildren(List<Explanation> children) {
        this.setChildren(children);
        return this;
    }

    public StreamExplanation withChildren(Explanation[] children) {
        Explanation[] explanationArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Explanation child = explanationArray[n2];
            this.addChild(child);
            ++n2;
        }
        return this;
    }

    public void addChild(Explanation child) {
        if (this.children == null) {
            this.children = new ArrayList<Explanation>(1);
        }
        this.children.add(child);
    }

    @Override
    public Map<String, Object> toMap(Map<String, Object> map) {
        map = super.toMap(map);
        if (this.children != null && this.children.size() != 0) {
            ArrayList<Map> childrenMaps = new ArrayList<Map>();
            for (Explanation child : this.children) {
                childrenMaps.add(child.toMap(new LinkedHashMap<String, Object>()));
            }
            map.put("children", childrenMaps);
        }
        return map;
    }
}

