/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.Precision;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.DbscanEvaluator;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ZplotStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map letParams = new LinkedHashMap();
    private Iterator<Tuple> out;

    public ZplotStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionParameter streamExpressionParameter : namedParams) {
            String name = ((StreamExpressionNamedParameter)streamExpressionParameter).getName();
            StreamExpressionParameter param = ((StreamExpressionNamedParameter)streamExpressionParameter).getParameter();
            if (param instanceof StreamExpressionValue) {
                String paramValue = ((StreamExpressionValue)param).getValue();
                this.letParams.put(name, factory.constructPrimitiveObject(paramValue));
                continue;
            }
            if (!factory.isEvaluator((StreamExpression)param)) continue;
            StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
            this.letParams.put(name, evaluator);
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out.hasNext()) {
            return this.out.next();
        }
        return Tuple.EOF();
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() throws IOException {
        Object o;
        Map<String, Object> lets = this.streamContext.getLets();
        Set entries = this.letParams.entrySet();
        HashMap<String, Object> evaluated = new HashMap<String, Object>();
        int numTuples = -1;
        int columns = 0;
        boolean table = false;
        boolean distribution = false;
        boolean clusters = false;
        boolean heat = false;
        for (Map.Entry entry : entries) {
            ++columns;
            String name = (String)entry.getKey();
            if (name.equals("table")) {
                table = true;
            } else if (name.equals("dist")) {
                distribution = true;
            } else if (name.equals("clusters")) {
                clusters = true;
            } else if (name.equals("heat")) {
                heat = true;
            }
            Object v = entry.getValue();
            if (v instanceof StreamEvaluator) {
                Tuple eTuple = new Tuple(lets);
                StreamEvaluator streamEvaluator = (StreamEvaluator)v;
                streamEvaluator.setStreamContext(this.streamContext);
                Object eo = streamEvaluator.evaluate(eTuple);
                if (eo instanceof List) {
                    List l2 = (List)eo;
                    if (numTuples == -1) {
                        numTuples = l2.size();
                    } else if (l2.size() != numTuples) {
                        throw new IOException("All lists provided to the zplot function must be the same length.");
                    }
                    evaluated.put(name, l2);
                    continue;
                }
                if (eo instanceof Tuple) {
                    evaluated.put(name, eo);
                    continue;
                }
                evaluated.put(name, eo);
                continue;
            }
            Iterator eval = lets.get(v);
            if (eval instanceof List) {
                List list = (List)((Object)eval);
                if (numTuples == -1) {
                    numTuples = list.size();
                } else if (list.size() != numTuples) {
                    throw new IOException("All lists provided to the zplot function must be the same length.");
                }
                evaluated.put(name, list);
                continue;
            }
            if (eval instanceof Tuple) {
                evaluated.put(name, eval);
                continue;
            }
            if (!(eval instanceof Matrix)) continue;
            evaluated.put(name, eval);
        }
        if (columns > 1 && (table || distribution)) {
            throw new IOException("If the table or dist parameter is set there can only be one parameter.");
        }
        ArrayList<Tuple> outTuples = new ArrayList<Tuple>();
        if (!(table || distribution || clusters || heat)) {
            int i = 0;
            while (i < numTuples) {
                Tuple tuple = new Tuple();
                for (Map.Entry entry : evaluated.entrySet()) {
                    List list = (List)entry.getValue();
                    tuple.put(entry.getKey(), list.get(i));
                }
                outTuples.add(tuple);
                ++i;
            }
            if (((Tuple)outTuples.get(0)).getFields().containsKey("y") && !((Tuple)outTuples.get(0)).getFields().containsKey("x")) {
                int x = 0;
                for (Tuple tuple : outTuples) {
                    tuple.put("x", x++);
                }
            }
        } else if (clusters) {
            o = evaluated.get("clusters");
            if (o instanceof KmeansEvaluator.ClusterTuple) {
                ct = (KmeansEvaluator.ClusterTuple)o;
                List<CentroidCluster<KmeansEvaluator.ClusterPoint>> list = ((KmeansEvaluator.ClusterTuple)ct).getClusters();
                int clusterNum = 0;
                for (CentroidCluster<KmeansEvaluator.ClusterPoint> centroidCluster : list) {
                    ++clusterNum;
                    points = centroidCluster.getPoints();
                    for (KmeansEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + clusterNum);
                        outTuples.add(tuple);
                    }
                }
            } else if (o instanceof DbscanEvaluator.ClusterTuple) {
                ct = (DbscanEvaluator.ClusterTuple)o;
                List<Cluster<DbscanEvaluator.ClusterPoint>> list = ((DbscanEvaluator.ClusterTuple)ct).getClusters();
                int clusterNum = 0;
                for (Cluster cluster : list) {
                    ++clusterNum;
                    points = cluster.getPoints();
                    for (DbscanEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + clusterNum);
                        outTuples.add(tuple);
                    }
                }
            }
        } else if (distribution) {
            List list;
            o = evaluated.get("dist");
            if (o instanceof RealDistribution) {
                void var13_23;
                RealDistribution realDistribution = (RealDistribution)o;
                Object var13_20 = null;
                if (realDistribution instanceof EmpiricalDistribution) {
                    EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)realDistribution;
                    List list2 = empiricalDistribution.getBinStats();
                } else {
                    double[] samples = realDistribution.sample(500000);
                    EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution(32);
                    empiricalDistribution.load(samples);
                    List list3 = empiricalDistribution.getBinStats();
                }
                double[] x = new double[var13_23.size()];
                double[] dArray = new double[var13_23.size()];
                int i = 0;
                while (i < var13_23.size()) {
                    x[i] = ((SummaryStatistics)var13_23.get(i)).getMean();
                    dArray[i] = realDistribution.density(x[i]);
                    ++i;
                }
                i = 0;
                while (i < x.length) {
                    Tuple tuple = new Tuple();
                    if (!Double.isNaN(x[i])) {
                        tuple.put("x", Precision.round((double)x[i], (int)2));
                        if (dArray[i] == Double.NEGATIVE_INFINITY || dArray[i] == Double.POSITIVE_INFINITY) {
                            tuple.put("y", 0);
                        } else {
                            tuple.put("y", dArray[i]);
                        }
                        outTuples.add(tuple);
                    }
                    ++i;
                }
            } else if (o instanceof IntegerDistribution) {
                IntegerDistribution integerDistribution = (IntegerDistribution)o;
                int[] nArray = integerDistribution.sample(50000);
                Frequency frequency = new Frequency();
                int[] p = nArray;
                int tuple = nArray.length;
                int i = 0;
                while (i < tuple) {
                    int n = p[i];
                    frequency.addValue(n);
                    ++i;
                }
                Iterator iterator = frequency.valuesIterator();
                ArrayList<Long> values = new ArrayList<Long>();
                while (iterator.hasNext()) {
                    values.add((Long)iterator.next());
                }
                System.out.println(values);
                int[] x = new int[values.size()];
                double[] y = new double[values.size()];
                int i3 = 0;
                while (i3 < values.size()) {
                    x[i3] = ((Long)values.get(i3)).intValue();
                    y[i3] = integerDistribution.probability(x[i3]);
                    ++i3;
                }
                int i2 = 0;
                while (i2 < x.length) {
                    Tuple tuple2 = new Tuple();
                    tuple2.put("x", x[i2]);
                    tuple2.put("y", y[i2]);
                    outTuples.add(tuple2);
                    ++i2;
                }
            } else if (o instanceof List && (list = (List)o).get(0) instanceof Tuple) {
                List list4 = (List)o;
                Tuple tuple = (Tuple)list4.get(0);
                if (tuple.getFields().containsKey("N")) {
                    for (Tuple tuple2 : list4) {
                        outtuple = new Tuple();
                        outtuple.put("x", Precision.round((double)((Double)tuple2.get("mean")), (int)2));
                        outtuple.put("y", tuple2.get("prob"));
                        outTuples.add(outtuple);
                    }
                } else if (tuple.getFields().containsKey("count")) {
                    for (Tuple tuple3 : list4) {
                        outtuple = new Tuple();
                        outtuple.put("x", tuple3.get("value"));
                        outtuple.put("y", tuple3.get("pct"));
                        outTuples.add(outtuple);
                    }
                }
            }
        } else if (table) {
            o = evaluated.get("table");
            if (o instanceof Matrix) {
                m = (Matrix)o;
                List<String> list = m.getRowLabels();
                colLabels = m.getColumnLabels();
                double[][] dArray = m.getData();
                int i = 0;
                while (i < dArray.length) {
                    rowLabel = null;
                    rowLabel = list != null ? list.get(i) : Integer.toString(i);
                    Tuple tuple = new Tuple();
                    tuple.put("rowLabel", rowLabel);
                    double[] row = dArray[i];
                    int j = 0;
                    while (j < row.length) {
                        String colLabel = null;
                        colLabel = colLabels != null ? colLabels.get(j) : "col" + Integer.toString(j);
                        tuple.put(colLabel, dArray[i][j]);
                        ++j;
                    }
                    outTuples.add(tuple);
                    ++i;
                }
            }
        } else if (heat && (o = evaluated.get("heat")) instanceof Matrix) {
            m = (Matrix)o;
            List<String> list = m.getRowLabels();
            colLabels = m.getColumnLabels();
            double[][] dArray = m.getData();
            int i = 0;
            while (i < dArray.length) {
                rowLabel = null;
                rowLabel = list != null ? list.get(i) : "row" + ZplotStream.pad(Integer.toString(i), dArray.length);
                double[] row = dArray[i];
                int j = 0;
                while (j < row.length) {
                    Tuple tuple = new Tuple();
                    tuple.put("y", rowLabel);
                    String colLabel = null;
                    colLabel = colLabels != null ? colLabels.get(j) : "col" + ZplotStream.pad(Integer.toString(j), row.length);
                    tuple.put("x", colLabel);
                    tuple.put("z", dArray[i][j]);
                    outTuples.add(tuple);
                    ++j;
                }
                ++i;
            }
        }
        this.out = outTuples.iterator();
    }

    public static String pad(String v, int length) {
        if (length < 11) {
            return v;
        }
        if (length < 101) {
            return ZplotStream.prepend(v, 2);
        }
        if (length < 1001) {
            return ZplotStream.prepend(v, 3);
        }
        if (length < 10001) {
            return ZplotStream.prepend(v, 4);
        }
        return ZplotStream.prepend(v, 5);
    }

    private static String prepend(String v, int length) {
        while (v.length() < length) {
            v = "0" + v;
        }
        return v;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

