/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;

public class ShuffleStream
extends CloudSolrStream
implements Expressible {
    public ShuffleStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter aliasExpression = factory.getNamedOperand(expression, "aliases");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (namedParams.size() == 0) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (aliasExpression != null && aliasExpression.getParameter() instanceof StreamExpressionValue) {
            this.fieldMappings = new HashMap();
            String[] stringArray = ((StreamExpressionValue)aliasExpression.getParameter()).getValue().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] parts = mapping.trim().split("=");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - alias expected of the format origName=newName", expression));
                }
                this.fieldMappings.put(parts[0], parts[1]);
                ++n2;
            }
        }
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, zkHost, mParams);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String[]> param : this.params.getMap().entrySet()) {
            String[] stringArray = param.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), val.replace("\"", "\\\"")));
                ++n2;
            }
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        if (this.fieldMappings != null && this.fieldMappings.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry mapping : this.fieldMappings.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append((String)mapping.getKey());
                sb.append("=");
                sb.append((String)mapping.getValue());
            }
            expression.addParameter(new StreamExpressionNamedParameter("aliases", sb.toString()));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (this.params != null) {
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public ModifiableSolrParams adjustParams(ModifiableSolrParams mParams) {
        mParams.set("qt", "/export");
        return mParams;
    }
}

