/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.HashKey;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class RollupStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private PushBackStream tupleStream;
    private Bucket[] buckets;
    private Metric[] metrics;
    private HashKey currentKey = new HashKey("-");
    private Metric[] currentMetrics;
    private boolean finished = false;

    public RollupStream(TupleStream tupleStream, Bucket[] buckets, Metric[] metrics) {
        this.init(tupleStream, buckets, metrics);
    }

    public RollupStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        StreamExpressionNamedParameter overExpression = factory.getNamedOperand(expression, "over");
        if (expression.getParameters().size() != streamExpressions.size() + metricExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (overExpression == null || !(overExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'over' parameter listing fields to rollup by but didn't find one", expression));
        }
        Metric[] metrics = new Metric[metricExpressions.size()];
        int idx = 0;
        while (idx < metricExpressions.size()) {
            metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
            ++idx;
        }
        StreamEqualitor streamEqualitor = factory.constructEqualitor(((StreamExpressionValue)overExpression.getParameter()).getValue(), FieldEqualitor.class);
        List<FieldEqualitor> flattenedEqualitors = this.flattenEqualitor(streamEqualitor);
        Bucket[] buckets = new Bucket[flattenedEqualitors.size()];
        int idx2 = 0;
        while (idx2 < flattenedEqualitors.size()) {
            buckets[idx2] = new Bucket(flattenedEqualitors.get(idx2).getLeftFieldName());
            ++idx2;
        }
        this.init(factory.constructStream(streamExpressions.get(0)), buckets, metrics);
    }

    private List<FieldEqualitor> flattenEqualitor(StreamEqualitor equalitor) {
        ArrayList<FieldEqualitor> flattenedList = new ArrayList<FieldEqualitor>();
        if (equalitor instanceof FieldEqualitor) {
            flattenedList.add((FieldEqualitor)equalitor);
        } else if (equalitor instanceof MultipleFieldEqualitor) {
            MultipleFieldEqualitor mEqualitor = (MultipleFieldEqualitor)equalitor;
            StreamEqualitor[] streamEqualitorArray = mEqualitor.getEqs();
            int n = streamEqualitorArray.length;
            int n2 = 0;
            while (n2 < n) {
                StreamEqualitor subEqualitor = streamEqualitorArray[n2];
                flattenedList.addAll(this.flattenEqualitor(subEqualitor));
                ++n2;
            }
        }
        return flattenedList;
    }

    private void init(TupleStream tupleStream, Bucket[] buckets, Metric[] metrics) {
        this.tupleStream = new PushBackStream(tupleStream);
        this.buckets = buckets;
        this.metrics = metrics;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            expression.addParameter(this.tupleStream.toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        StringBuilder overBuilder = new StringBuilder();
        Object[] objectArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            Bucket bucket = objectArray[n2];
            if (overBuilder.length() > 0) {
                overBuilder.append(",");
            }
            overBuilder.append(bucket.toString());
            ++n2;
        }
        expression.addParameter(new StreamExpressionNamedParameter("over", overBuilder.toString()));
        objectArray = this.metrics;
        n = this.metrics.length;
        n2 = 0;
        while (n2 < n) {
            Object metric = objectArray[n2];
            expression.addParameter(metric.toExpression(factory));
            ++n2;
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        Explanation explanation = new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.tupleStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
        Metric[] metricArray = this.metrics;
        int n = this.metrics.length;
        int n2 = 0;
        while (n2 < n) {
            Metric metric = metricArray[n2];
            explanation.withHelper(metric.toExplanation(factory));
            ++n2;
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
        this.currentMetrics = null;
        this.currentKey = new HashKey("-");
        this.finished = false;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple t;
        block0: while (true) {
            int i;
            int n;
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                if (!this.finished) {
                    if (this.currentMetrics == null) {
                        return tuple;
                    }
                    Tuple t2 = new Tuple();
                    Metric[] metricArray = this.currentMetrics;
                    n = this.currentMetrics.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Metric metric = metricArray[n2];
                        t2.put(metric.getIdentifier(), metric.getValue());
                        ++n2;
                    }
                    int i2 = 0;
                    while (i2 < this.buckets.length) {
                        t2.put(this.buckets[i2].toString(), this.currentKey.getParts()[i2]);
                        ++i2;
                    }
                    this.tupleStream.pushBack(tuple);
                    this.finished = true;
                    return t2;
                }
                return tuple;
            }
            Object[] bucketValues = new Object[this.buckets.length];
            int i3 = 0;
            while (i3 < this.buckets.length) {
                bucketValues[i3] = this.buckets[i3].getBucketValue(tuple);
                ++i3;
            }
            HashKey hashKey = new HashKey(bucketValues);
            if (hashKey.equals(this.currentKey)) {
                Metric[] metricArray = this.currentMetrics;
                int n3 = this.currentMetrics.length;
                n = 0;
                while (true) {
                    if (n >= n3) continue block0;
                    Metric bucketMetric = metricArray[n];
                    bucketMetric.update(tuple);
                    ++n;
                }
            }
            t = null;
            if (this.currentMetrics != null) {
                t = new Tuple();
                Metric[] metricArray = this.currentMetrics;
                int n4 = this.currentMetrics.length;
                int n5 = 0;
                while (n5 < n4) {
                    Metric metric = metricArray[n5];
                    t.put(metric.getIdentifier(), metric.getValue());
                    ++n5;
                }
                i = 0;
                while (i < this.buckets.length) {
                    t.put(this.buckets[i].toString(), this.currentKey.getParts()[i]);
                    ++i;
                }
            }
            this.currentKey = hashKey;
            if (this.metrics != null) {
                this.currentMetrics = new Metric[this.metrics.length];
                i = 0;
                while (i < this.metrics.length) {
                    Metric bucketMetric = this.metrics[i].newInstance();
                    bucketMetric.update(tuple);
                    this.currentMetrics[i] = bucketMetric;
                    ++i;
                }
            }
            if (t != null) break;
        }
        return t;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.tupleStream.getStreamSort();
    }
}

