/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.ops.ReduceOperation;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ReducerStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private PushBackStream stream;
    private StreamEqualitor eq;
    private ReduceOperation op;
    private boolean needsReduce;
    private transient Tuple currentGroupHead;

    public ReducerStream(TupleStream stream, StreamEqualitor eq, ReduceOperation op) throws IOException {
        this.init(stream, eq, op);
    }

    public ReducerStream(TupleStream stream, StreamComparator comp, ReduceOperation op) throws IOException {
        this.init(stream, this.convertToEqualitor(comp), op);
    }

    private StreamEqualitor convertToEqualitor(StreamComparator comp) {
        if (comp instanceof MultipleFieldComparator) {
            MultipleFieldComparator mComp = (MultipleFieldComparator)comp;
            StreamEqualitor[] eqs = new StreamEqualitor[mComp.getComps().length];
            int idx = 0;
            while (idx < mComp.getComps().length) {
                eqs[idx] = this.convertToEqualitor(mComp.getComps()[idx]);
                ++idx;
            }
            return new MultipleFieldEqualitor(eqs);
        }
        FieldComparator fComp = (FieldComparator)comp;
        return new FieldEqualitor(fComp.getLeftFieldName(), fComp.getRightFieldName());
    }

    public ReducerStream(StreamExpression expression, StreamFactory factory) throws IOException {
        StreamOperation operation;
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter byExpression = factory.getNamedOperand(expression, "by");
        List<StreamExpression> operationExpressions = factory.getExpressionOperandsRepresentingTypes(expression, ReduceOperation.class);
        if (expression.getParameters().size() != streamExpressions.size() + 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (byExpression == null || !(byExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'by' parameter listing fields to group by but didn't find one", expression));
        }
        ReduceOperation reduceOperation = null;
        if (operationExpressions != null && operationExpressions.size() == 1) {
            StreamExpression ex = operationExpressions.get(0);
            operation = factory.constructOperation(ex);
            if (!(operation instanceof ReduceOperation)) {
                throw new IOException("The ReducerStream requires a ReduceOperation. A StreamOperation was provided.");
            }
        } else {
            throw new IOException("The ReducerStream requires a ReduceOperation.");
        }
        reduceOperation = (ReduceOperation)operation;
        this.init(factory.constructStream(streamExpressions.get(0)), factory.constructEqualitor(((StreamExpressionValue)byExpression.getParameter()).getValue(), FieldEqualitor.class), reduceOperation);
    }

    private void init(TupleStream stream, StreamEqualitor eq, ReduceOperation op) throws IOException {
        this.stream = new PushBackStream(stream);
        this.eq = eq;
        this.op = op;
        if (!eq.isDerivedFrom(stream.getStreamSort())) {
            throw new IOException("Invalid ReducerStream - substream comparator (sort) must be a superset of this stream's comparator.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            expression.addParameter(this.stream.toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        if (!(this.eq instanceof Expressible)) {
            throw new IOException("This ReducerStream contains a non-expressible comparator - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("by", this.eq.toExpression(factory)));
        if (!(this.op instanceof Expressible)) {
            throw new IOException("This ReducerStream contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.op.toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelpers(new Explanation[]{this.eq.toExplanation(factory), this.op.toExplanation(factory)});
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple t;
        while (true) {
            t = this.stream.read();
            if (t.EOF) {
                if (this.needsReduce) {
                    this.stream.pushBack(t);
                    this.needsReduce = false;
                    return this.op.reduce();
                }
                return t;
            }
            if (this.currentGroupHead == null) {
                this.currentGroupHead = t;
                this.op.operate(t);
                this.needsReduce = true;
                continue;
            }
            if (!this.eq.test(this.currentGroupHead, t)) break;
            this.op.operate(t);
            this.needsReduce = true;
        }
        this.stream.pushBack(t);
        this.currentGroupHead = null;
        this.needsReduce = false;
        return this.op.reduce();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

