/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.DeepRandomStream;
import org.apache.solr.client.solrj.io.stream.RandomStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class RandomFacadeStream
extends TupleStream
implements Expressible {
    private TupleStream innerStream;

    public RandomFacadeStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("buckets") || namedParam.getName().equals("bucketSorts") || namedParam.getName().equals("limit")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (!params.containsKey("q")) {
            params.put("q", "*:*");
        }
        if (!params.containsKey("fl")) {
            params.put("fl", "*");
        }
        if (!params.containsKey("rows")) {
            params.put("rows", "500");
        }
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        if (params.get("rows") != null) {
            int rows = Integer.parseInt((String)params.get("rows"));
            if (rows >= 5000) {
                DeepRandomStream deepRandomStream = new DeepRandomStream();
                deepRandomStream.init(collectionName, zkHost, this.toSolrParams(params));
                this.innerStream = deepRandomStream;
            } else {
                RandomStream randomStream = new RandomStream();
                randomStream.init(zkHost, collectionName, params);
                this.innerStream = randomStream;
            }
        } else {
            RandomStream randomStream = new RandomStream();
            randomStream.init(zkHost, collectionName, params);
            this.innerStream = randomStream;
        }
    }

    private SolrParams toSolrParams(Map<String, String> props) {
        ModifiableSolrParams sp = new ModifiableSolrParams();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sp.add(entry.getKey(), entry.getValue());
        }
        return sp;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return ((Expressible)((Object)this.innerStream)).toExpression(factory);
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return this.innerStream.toExplanation(factory);
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.innerStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        return this.innerStream.children();
    }

    @Override
    public void open() throws IOException {
        this.innerStream.open();
    }

    @Override
    public void close() throws IOException {
        this.innerStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.innerStream.read();
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }
}

