/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;

public class ParallelStream
extends CloudSolrStream
implements Expressible {
    private TupleStream tupleStream;
    private int workers;
    private transient StreamFactory streamFactory;

    public ParallelStream(String zkHost, String collection, TupleStream tupleStream, int workers, StreamComparator comp) throws IOException {
        this.init(zkHost, collection, tupleStream, workers, comp);
    }

    public ParallelStream(String zkHost, String collection, String expressionString, int workers, StreamComparator comp) throws IOException {
        TupleStream tStream = this.streamFactory.constructStream(expressionString);
        this.init(zkHost, collection, tStream, workers, comp);
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public ParallelStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        StreamExpressionNamedParameter workersParam = factory.getNamedOperand(expression, "workers");
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != streamExpressions.size() + 3 + (zkHostExpression != null ? 1 : 0)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (workersParam == null || workersParam.getParameter() == null || !(workersParam.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single 'workers' parameter of type positive integer but didn't find one", expression));
        }
        String workersStr = ((StreamExpressionValue)workersParam.getParameter()).getValue();
        int workersInt = 0;
        try {
            workersInt = Integer.parseInt(workersStr);
            if (workersInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' must be greater than 0.", expression, workersStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' is not a valid integer.", expression, workersStr));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (sortExpression == null || !(sortExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'sort' parameter telling us how to join the parallel streams but didn't find one", expression));
        }
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        StreamComparator comp = factory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        this.streamFactory = factory;
        this.init(zkHost, collectionName, stream, workersInt, comp);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, int workers, StreamComparator comp) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.workers = workers;
        this.comp = comp;
        this.tupleStream = tupleStream;
        if (!(tupleStream instanceof Expressible)) {
            throw new IOException("Unable to create ParallelStream with a non-expressible TupleStream.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("workers", Integer.toString(this.workers)));
        if (includeStreams) {
            if (!(this.tupleStream instanceof Expressible)) throw new IOException("This ParallelStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.comp.toExpression(factory)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        int idx = 0;
        while (idx < this.workers) {
            explanation.addChild(this.tupleStream.toExplanation(factory));
            ++idx;
        }
        return explanation;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            return Tuple.EOF();
        }
        return tuple;
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        if (this.streamFactory == null) {
            this.streamFactory = streamContext.getStreamFactory();
        }
        this.tupleStream.setStreamContext(streamContext);
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            StreamExpressionParameter pushStream = ((Expressible)((Object)this.tupleStream)).toExpression(this.streamFactory);
            List<String> shardUrls = ParallelStream.getShards(this.zkHost, this.collection, this.streamContext);
            int w = 0;
            while (w < this.workers) {
                ModifiableSolrParams paramsLoc = new ModifiableSolrParams();
                paramsLoc.set("distrib", "false");
                paramsLoc.set("numWorkers", this.workers);
                paramsLoc.set("workerID", w);
                paramsLoc.set("expr", pushStream.toString());
                paramsLoc.set("qt", "/stream");
                String url = shardUrls.get(w);
                SolrStream solrStream = new SolrStream(url, paramsLoc);
                solrStream.setStreamContext(this.streamContext);
                this.solrStreams.add(solrStream);
                ++w;
            }
            assert (this.solrStreams.size() == this.workers);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

