/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;

public class ParallelListStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream[] streams;
    private TupleStream currentStream;
    private int streamIndex;

    public ParallelListStream(TupleStream ... streams) throws IOException {
        this.init(streams);
    }

    public ParallelListStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        TupleStream[] streams = new TupleStream[streamExpressions.size()];
        int idx = 0;
        while (idx < streamExpressions.size()) {
            streams[idx] = factory.constructStream(streamExpressions.get(idx));
            ++idx;
        }
        this.init(streams);
    }

    private void init(TupleStream ... tupleStreams) {
        this.streams = tupleStreams;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            TupleStream[] tupleStreamArray = this.streams;
            int n = this.streams.length;
            int n2 = 0;
            while (n2 < n) {
                TupleStream stream = tupleStreamArray[n2];
                expression.addParameter(((Expressible)((Object)stream)).toExpression(factory));
                ++n2;
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        TupleStream[] tupleStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            TupleStream stream = tupleStreamArray[n2];
            explanation.addChild(stream.toExplanation(factory));
            ++n2;
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        TupleStream[] tupleStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            TupleStream stream = tupleStreamArray[n2];
            stream.setStreamContext(context);
            ++n2;
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        TupleStream[] tupleStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            TupleStream stream = tupleStreamArray[n2];
            l.add(stream);
            ++n2;
        }
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple;
        while (true) {
            if (this.currentStream == null) {
                if (this.streamIndex < this.streams.length) {
                    this.currentStream = this.streams[this.streamIndex];
                } else {
                    return Tuple.EOF();
                }
            }
            tuple = this.currentStream.read();
            if (!tuple.EOF) break;
            this.currentStream.close();
            this.currentStream = null;
            ++this.streamIndex;
        }
        return tuple;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        this.openStreams();
    }

    private void openStreams() throws IOException {
        ExecutorService service = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("ParallelListStream"));
        try {
            ArrayList<Future<StreamIndex>> futures = new ArrayList<Future<StreamIndex>>();
            int i = 0;
            TupleStream[] tupleStreamArray = this.streams;
            int n = this.streams.length;
            int n2 = 0;
            while (n2 < n) {
                TupleStream tupleStream = tupleStreamArray[n2];
                StreamOpener so = new StreamOpener(new StreamIndex(tupleStream, i++));
                Future<StreamIndex> future = service.submit(so);
                futures.add(future);
                ++n2;
            }
            try {
                for (Future future : futures) {
                    StreamIndex streamIndex = (StreamIndex)future.get();
                    this.streams[streamIndex.getIndex()] = streamIndex.getTupleStream();
                }
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }

    protected class StreamIndex {
        private TupleStream tupleStream;
        private int index;

        public StreamIndex(TupleStream tupleStream, int index) {
            this.tupleStream = tupleStream;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public TupleStream getTupleStream() {
            return this.tupleStream;
        }
    }

    protected class StreamOpener
    implements Callable<StreamIndex> {
        private StreamIndex streamIndex;

        public StreamOpener(StreamIndex streamIndex) {
            this.streamIndex = streamIndex;
        }

        @Override
        public StreamIndex call() throws Exception {
            this.streamIndex.getTupleStream().open();
            return this.streamIndex;
        }
    }
}

