/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class KnnStream
extends TupleStream
implements Expressible {
    private static String[] mltParams = new String[]{"qf", "mintf", "mindf", "maxdf", "minwl", "maxwl", "maxqt", "maxntp", "boost"};
    private String zkHost;
    private Map<String, String> props;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    private Iterator<SolrDocument> documentIterator;
    private String id;

    public KnnStream(String zkHost, String collection, String id, Map<String, String> props) throws IOException {
        this.init(zkHost, collection, id, props);
    }

    public KnnStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        StreamExpressionNamedParameter idExpression = factory.getNamedOperand(expression, "id");
        StreamExpressionNamedParameter qfExpression = factory.getNamedOperand(expression, "qf");
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (namedParams.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least two named parameters expected. eg. 'id' and 'qf'", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("id")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String id = null;
        if (idExpression == null) {
            throw new IOException("id parameter is expected for KnnStream");
        }
        id = ((StreamExpressionValue)idExpression.getParameter()).getValue();
        if (qfExpression == null) {
            throw new IOException("qf parameter is expected for KnnStream");
        }
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, id, params);
    }

    private void init(String zkHost, String collection, String id, Map<String, String> props) throws IOException {
        this.zkHost = zkHost;
        this.props = props;
        this.collection = collection;
        this.id = id;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String> param : this.props.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), param.getValue()));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (this.props != null) {
            child.setExpression(this.props.entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        ModifiableSolrParams params = this.getParams(this.props);
        StringBuilder builder = new StringBuilder();
        String[] stringArray = mltParams;
        int n = mltParams.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (params.get(key) != null) {
                builder.append(' ').append(key).append('=').append(params.get(key));
                params.remove(key);
            }
            ++n2;
        }
        String k = params.get("k");
        if (k != null) {
            params.add("rows", k);
            params.remove(k);
        }
        params.add("q", "{!mlt" + builder.toString() + "}" + this.id);
        QueryRequest request = new QueryRequest(params);
        try {
            QueryResponse response = (QueryResponse)request.process(this.cloudSolrClient, this.collection);
            SolrDocumentList docs = response.getResults();
            this.documentIterator = docs.iterator();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Tuple read() throws IOException {
        if (this.documentIterator.hasNext()) {
            Tuple tuple = new Tuple();
            SolrDocument doc = this.documentIterator.next();
            for (Map.Entry<String, Object> entry : doc.entrySet()) {
                tuple.put(entry.getKey(), entry.getValue());
            }
            return tuple;
        }
        return Tuple.EOF();
    }

    private ModifiableSolrParams getParams(Map<String, String> props) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = entry.getValue();
            params.add(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }
}

