/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HashJoinStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected TupleStream hashStream;
    protected TupleStream fullStream;
    protected List<String> leftHashOn;
    protected List<String> rightHashOn;
    protected HashMap<String, List<Tuple>> hashedTuples;
    protected Tuple workingFullTuple = null;
    protected String workingFullHash = null;
    protected int workngHashSetIdx = 0;

    public HashJoinStream(TupleStream fullStream, TupleStream hashStream, List<String> hashOn) throws IOException {
        this.init(fullStream, hashStream, hashOn);
    }

    public HashJoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter hashStreamExpression = factory.getNamedOperand(expression, "hashed");
        StreamExpressionNamedParameter onExpression = factory.getNamedOperand(expression, "on");
        if (expression.getParameters().size() != streamExpressions.size() + 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two streams but found %d", expression, streamExpressions.size()));
        }
        if (hashStreamExpression == null || !(hashStreamExpression.getParameter() instanceof StreamExpression)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'hashed' parameter containing the stream to hash but didn't find one", expression));
        }
        if (onExpression == null || !(onExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'on' parameter listing fields to hash on but didn't find one", expression));
        }
        String hashOnValue = ((StreamExpressionValue)onExpression.getParameter()).getValue();
        String[] parts = hashOnValue.split(",");
        ArrayList<String> hashOn = new ArrayList<String>(parts.length);
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            hashOn.add(part.trim());
            ++n2;
        }
        this.init(factory.constructStream(streamExpressions.get(0)), factory.constructStream((StreamExpression)hashStreamExpression.getParameter()), hashOn);
    }

    private void init(TupleStream fullStream, TupleStream hashStream, List<String> hashOn) throws IOException {
        this.fullStream = fullStream;
        this.hashStream = hashStream;
        this.hashedTuples = new HashMap();
        this.leftHashOn = new ArrayList<String>();
        this.rightHashOn = new ArrayList<String>();
        for (String hasher : hashOn) {
            String[] parts = hasher.split("=");
            if (1 == parts.length) {
                String field = parts[0].trim();
                this.leftHashOn.add(field);
                this.rightHashOn.add(field);
                continue;
            }
            if (2 == parts.length) {
                this.leftHashOn.add(parts[0].trim());
                this.rightHashOn.add(parts[1].trim());
                continue;
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - invalid 'on' parameter - expecting 1 or more instances if 'field' or 'field=hashedField' but found '%s'", hasher));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.hashStream instanceof Expressible) || !(this.fullStream instanceof Expressible)) throw new IOException("This HashJoinStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.fullStream)).toExpression(factory));
            expression.addParameter(new StreamExpressionNamedParameter("hashed", ((Expressible)((Object)this.hashStream)).toExpression(factory)));
        } else {
            expression.addParameter("<stream>");
            expression.addParameter("hashed=<stream>");
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        while (idx < this.leftHashOn.size()) {
            String right;
            String left;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((left = this.leftHashOn.get(idx)).equals(right = this.rightHashOn.get(idx))) {
                sb.append(left);
            } else {
                sb.append(left);
                sb.append("=");
                sb.append(right);
            }
            ++idx;
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", sb.toString()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.fullStream.toExplanation(factory), this.hashStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.hashStream.setStreamContext(context);
        this.fullStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.hashStream);
        l.add(this.fullStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.hashStream.open();
        this.fullStream.open();
        Tuple tuple = this.hashStream.read();
        while (!tuple.EOF) {
            String hash = this.computeHash(tuple, this.rightHashOn);
            if (hash != null) {
                if (this.hashedTuples.containsKey(hash)) {
                    this.hashedTuples.get(hash).add(tuple);
                } else {
                    ArrayList<Tuple> set = new ArrayList<Tuple>();
                    set.add(tuple);
                    this.hashedTuples.put(hash, set);
                }
            }
            tuple = this.hashStream.read();
        }
    }

    protected String computeHash(Tuple tuple, List<String> hashOn) {
        StringBuilder sb = new StringBuilder();
        for (String part : hashOn) {
            Object obj = tuple.get(part);
            if (obj == null) {
                return null;
            }
            sb.append(obj.toString());
            sb.append("::");
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.hashStream.close();
        this.fullStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        while (this.workingFullTuple == null) {
            Tuple fullTuple = this.fullStream.read();
            if (fullTuple.EOF) {
                return fullTuple;
            }
            String fullHash = this.computeHash(fullTuple, this.leftHashOn);
            if (fullHash == null || !this.hashedTuples.containsKey(fullHash)) continue;
            this.workingFullTuple = fullTuple;
            this.workingFullHash = fullHash;
            this.workngHashSetIdx = 0;
        }
        List<Tuple> matches = this.hashedTuples.get(this.workingFullHash);
        Tuple returnTuple = this.workingFullTuple.clone();
        returnTuple.merge(matches.get(this.workngHashSetIdx));
        ++this.workngHashSetIdx;
        if (this.workngHashSetIdx >= matches.size()) {
            this.workingFullTuple = null;
            this.workingFullHash = null;
            this.workngHashSetIdx = 0;
        }
        return returnTuple;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.fullStream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

