/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;

public class DrillStream
extends CloudSolrStream
implements Expressible {
    private TupleStream tupleStream;
    private transient StreamFactory streamFactory;
    private String sort;
    private String fl;
    private String q;

    public DrillStream(String zkHost, String collection, TupleStream tupleStream, StreamComparator comp, String sortParam, String flParam, String qParam) throws IOException {
        this.init(zkHost, collection, tupleStream, comp, sortParam, flParam, qParam);
    }

    public DrillStream(String zkHost, String collection, String expressionString, StreamComparator comp, String sortParam, String flParam, String qParam) throws IOException {
        TupleStream tStream = this.streamFactory.constructStream(expressionString);
        this.init(zkHost, collection, tStream, comp, sortParam, flParam, qParam);
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public DrillStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter qExpression = factory.getNamedOperand(expression, "q");
        StreamExpressionNamedParameter flExpression = factory.getNamedOperand(expression, "fl");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        String sortParam = null;
        if (sortExpression == null || !(sortExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'sort' parameter but didn't find one", expression));
        }
        sortParam = ((StreamExpressionValue)sortExpression.getParameter()).getValue();
        String flParam = null;
        if (flExpression == null || !(flExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'fl' parameter but didn't find one", expression));
        }
        flParam = ((StreamExpressionValue)flExpression.getParameter()).getValue();
        String qParam = null;
        if (qExpression == null || !(qExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'q' parameter but didn't find one", expression));
        }
        qParam = ((StreamExpressionValue)qExpression.getParameter()).getValue();
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        StreamFactory localFactory = (StreamFactory)factory.clone();
        localFactory.withDefaultSort(sortParam);
        TupleStream stream = localFactory.constructStream(streamExpressions.get(0));
        StreamComparator comp = localFactory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        this.streamFactory = factory;
        this.init(zkHost, collectionName, stream, comp, sortParam, flParam, qParam);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, StreamComparator comp, String sortParam, String flParam, String qParam) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.comp = comp;
        this.tupleStream = tupleStream;
        this.fl = flParam;
        this.q = qParam;
        this.sort = sortParam;
        if (!(tupleStream instanceof Expressible)) {
            throw new IOException("Unable to create DrillStream with a non-expressible TupleStream.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        if (includeStreams) {
            if (!(this.tupleStream instanceof Expressible)) throw new IOException("This DrillStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.comp.toExpression(factory)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            return Tuple.EOF();
        }
        return tuple;
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        if (this.streamFactory == null) {
            this.streamFactory = streamContext.getStreamFactory();
        }
        this.tupleStream.setStreamContext(streamContext);
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            StreamExpressionParameter pushStream = ((Expressible)((Object)this.tupleStream)).toExpression(this.streamFactory);
            ModifiableSolrParams paramsLoc = new ModifiableSolrParams();
            paramsLoc.set("distrib", "false");
            paramsLoc.set("expr", pushStream.toString());
            paramsLoc.set("qt", "/export");
            paramsLoc.set("fl", this.fl);
            paramsLoc.set("sort", this.sort);
            paramsLoc.set("q", this.q);
            DrillStream.getReplicas(this.zkHost, this.collection, this.streamContext, paramsLoc).forEach(r -> {
                SolrStream solrStream = new SolrStream(r.getBaseUrl(), paramsLoc, r.getCoreName());
                solrStream.setStreamContext(this.streamContext);
                this.solrStreams.add(solrStream);
            });
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof IOException) {
                throw (IOException)rootCause;
            }
            throw new IOException(e);
        }
    }
}

