/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonStream
extends TupleStream
implements Expressible {
    private TupleStream tupleStream;
    private StreamRunner streamRunner;
    private ArrayBlockingQueue<Tuple> queue;
    private int queueSize;
    private boolean eatTuples;
    private AtomicLong iterations = new AtomicLong();
    private long startTime;
    private long stopTime;
    private Exception exception;
    private long runInterval;
    private String id;
    private Map<String, DaemonStream> daemons;
    private boolean terminate;
    private boolean closed = false;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DaemonStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        TupleStream tupleStream = factory.constructStream(streamExpressions.get(0));
        StreamExpressionNamedParameter idExpression = factory.getNamedOperand(expression, "id");
        StreamExpressionNamedParameter runExpression = factory.getNamedOperand(expression, "runInterval");
        StreamExpressionNamedParameter queueExpression = factory.getNamedOperand(expression, "queueSize");
        StreamExpressionNamedParameter terminateExpression = factory.getNamedOperand(expression, "terminate");
        String id = null;
        long runInterval = 0L;
        int queueSize = 0;
        boolean terminate = false;
        if (idExpression == null) {
            throw new IOException("Invalid expression id parameter expected");
        }
        id = ((StreamExpressionValue)idExpression.getParameter()).getValue();
        runInterval = runExpression == null ? 2000L : Long.parseLong(((StreamExpressionValue)runExpression.getParameter()).getValue());
        if (queueExpression != null) {
            queueSize = Integer.parseInt(((StreamExpressionValue)queueExpression.getParameter()).getValue());
        }
        if (terminateExpression != null) {
            terminate = Boolean.parseBoolean(((StreamExpressionValue)terminateExpression.getParameter()).getValue());
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.init(tupleStream, id, runInterval, queueSize, terminate);
    }

    public DaemonStream(TupleStream tupleStream, String id, long runInterval, int queueSize, boolean terminate) {
        this.init(tupleStream, id, runInterval, queueSize, terminate);
    }

    public DaemonStream(TupleStream tupleStream, String id, long runInterval, int queueSize) {
        this(tupleStream, id, runInterval, queueSize, false);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.tupleStream instanceof Expressible)) throw new IOException("This UniqueStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("id", this.id));
        expression.addParameter(new StreamExpressionNamedParameter("runInterval", Long.toString(this.runInterval)));
        expression.addParameter(new StreamExpressionNamedParameter("queueSize", Integer.toString(this.queueSize)));
        expression.addParameter(new StreamExpressionNamedParameter("terminate", Boolean.toString(this.terminate)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.tupleStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public void init(TupleStream tupleStream, String id, long runInterval, int queueSize) {
        this.init(tupleStream, id, runInterval, queueSize, false);
    }

    public void init(TupleStream tupleStream, String id, long runInterval, int queueSize, boolean terminate) {
        this.tupleStream = tupleStream;
        this.id = id;
        this.runInterval = runInterval;
        this.queueSize = queueSize;
        this.terminate = terminate;
        if (queueSize > 0) {
            this.queue = new ArrayBlockingQueue(queueSize);
            this.eatTuples = false;
        } else {
            this.eatTuples = true;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DaemonStream) {
            return this.id.equals(((DaemonStream)o).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void open() throws IOException {
        if (this.streamRunner != null && !this.closed) {
            log.error("There is already a running daemon named '{}', no action taken", (Object)this.id);
            throw new IOException("There is already an open daemon named '" + this.id + "', no action taken.");
        }
        this.closed = false;
        this.streamRunner = new StreamRunner(this.runInterval, this.id);
        ExecutorService service = ExecutorUtil.newMDCAwareSingleThreadExecutor(new SolrNamedThreadFactory("DaemonStream-" + this.id));
        try {
            service.submit(this.streamRunner);
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            return this.queue.take();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.tupleStream.getStreamSort();
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.tupleStream.setStreamContext(streamContext);
    }

    public void shutdown() {
        this.streamRunner.setShutdown(true);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.streamRunner != null) {
            this.streamRunner.setShutdown(true);
        }
        this.closed = true;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> children = new ArrayList<TupleStream>();
        children.add(this.tupleStream);
        return children;
    }

    public synchronized Tuple getInfo() {
        Tuple tuple = new Tuple();
        tuple.put("id", this.id);
        tuple.put("startTime", this.startTime);
        tuple.put("stopTime", this.stopTime);
        tuple.put("iterations", this.iterations.get());
        tuple.put("state", this.streamRunner.getState().toString());
        if (this.exception != null) {
            tuple.put("exception", this.exception.getMessage());
        }
        return tuple;
    }

    public void setDaemons(Map<String, DaemonStream> daemons) {
        this.daemons = daemons;
    }

    private synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private synchronized void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    private class StreamRunner
    implements Runnable {
        private long sleepMillis = 1000L;
        private long runInterval;
        private long lastRun;
        private String id;
        private volatile Thread executingThread;
        private boolean shutdown;

        public StreamRunner(long runInterval, String id) {
            this.runInterval = runInterval;
            this.id = id;
        }

        public synchronized void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        public synchronized boolean getShutdown() {
            return this.shutdown;
        }

        public Thread.State getState() {
            if (this.executingThread == null) {
                if (this.shutdown) {
                    return Thread.State.TERMINATED;
                }
                return Thread.State.NEW;
            }
            return this.executingThread.getState();
        }

        @Override
        public void run() {
            this.executingThread = Thread.currentThread();
            try {
                this.stream();
            }
            finally {
                this.setShutdown(true);
                this.executingThread = null;
            }
        }

        /*
         * Exception decompiling
         */
        private void stream() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 29[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

