/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.FieldValueEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CartesianProductStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private List<NamedEvaluator> evaluators;
    private StreamComparator orderBy;
    private LinkedList<Tuple> generatedTuples;

    public CartesianProductStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = factory.getFunctionName(this.getClass());
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpressionParameter> evaluateAsExpressions = factory.getOperandsOfType(expression, StreamExpressionValue.class);
        StreamExpressionNamedParameter orderByExpression = factory.getNamedOperand(expression, "productSort");
        if (expression.getParameters().size() != streamExpressions.size() + evaluateAsExpressions.size() + (orderByExpression == null ? 0 : 1)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid %s expression %s - unknown operands found", functionName, expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid %s expression %s - expecting single stream but found %d (must be TupleStream types)", functionName, expression, streamExpressions.size()));
        }
        this.stream = factory.constructStream(streamExpressions.get(0));
        this.orderBy = orderByExpression == null ? null : factory.constructComparator(((StreamExpressionValue)orderByExpression.getParameter()).getValue(), FieldComparator.class);
        this.evaluators = new ArrayList<NamedEvaluator>();
        for (StreamExpressionParameter evaluateAsExpression : evaluateAsExpressions) {
            String fullString;
            String originalFullString = fullString = ((StreamExpressionValue)evaluateAsExpression).getValue().trim();
            if (fullString.length() > 2 && fullString.startsWith("\"") && fullString.endsWith("\"")) {
                fullString = fullString.substring(1, fullString.length() - 1).trim();
            }
            String evaluatorPart = null;
            String asNamePart = null;
            if (fullString.toLowerCase(Locale.ROOT).contains(" as ")) {
                String[] parts = fullString.split("(?i) as ");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "Invalid %s expression %s - expecting evaluator of form 'fieldA' or 'fieldA as alias' but found %s", functionName, expression, originalFullString));
                }
                evaluatorPart = parts[0].trim();
                asNamePart = parts[1].trim();
            } else {
                evaluatorPart = fullString;
            }
            boolean wasHandledAsEvaluatorFunction = false;
            StreamEvaluator evaluator = null;
            if (evaluatorPart.contains("(")) {
                try {
                    StreamExpression asValueExpression = StreamExpressionParser.parse(evaluatorPart);
                    if (factory.doesRepresentTypes(asValueExpression, StreamEvaluator.class)) {
                        evaluator = factory.constructEvaluator(asValueExpression);
                        wasHandledAsEvaluatorFunction = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!wasHandledAsEvaluatorFunction) {
                evaluator = new FieldValueEvaluator(evaluatorPart);
                if (asNamePart == null) {
                    asNamePart = evaluatorPart;
                }
            }
            if (evaluator == null || asNamePart == null) {
                throw new IOException(String.format(Locale.ROOT, "Invalid %s expression %s - failed to parse evaluator '%s'", functionName, expression, originalFullString));
            }
            this.evaluators.add(new NamedEvaluator(asNamePart, evaluator));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        for (NamedEvaluator evaluator : this.evaluators) {
            expression.addParameter(String.format(Locale.ROOT, "%s as %s", evaluator.getEvaluator().toExpression(factory), evaluator.getName()));
        }
        if (this.orderBy != null) {
            expression.addParameter(new StreamExpressionNamedParameter("productSort", this.orderBy.toExpression(factory)));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        Explanation explanation = new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
        for (NamedEvaluator evaluator : this.evaluators) {
            explanation.addHelper(evaluator.getEvaluator().toExplanation(factory));
        }
        if (this.orderBy != null) {
            explanation.addHelper(this.orderBy.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.generatedTuples.isEmpty()) {
            Tuple tuple = this.stream.read();
            if (tuple.EOF) {
                return tuple;
            }
            this.generatedTuples = this.generateTupleList(tuple);
        }
        return this.generatedTuples.pop();
    }

    private LinkedList<Tuple> generateTupleList(Tuple original) throws IOException {
        HashMap<String, Object> evaluatedValues = new HashMap<String, Object>();
        for (NamedEvaluator evaluator : this.evaluators) {
            evaluatedValues.put(evaluator.getName(), evaluator.getEvaluator().evaluate(original));
        }
        ArrayList<Tuple> generatedTupleList = new ArrayList<Tuple>();
        int[] workingIndexes = new int[this.evaluators.size()];
        do {
            Tuple generated = original.clone();
            int offset = 0;
            while (offset < workingIndexes.length) {
                String fieldName = this.evaluators.get(offset).getName();
                Object evaluatedValue = evaluatedValues.get(fieldName);
                if (evaluatedValue instanceof Collection) {
                    generated.put(fieldName, ((List)evaluatedValue).get(workingIndexes[offset]));
                }
                ++offset;
            }
            generatedTupleList.add(generated);
        } while (this.iterate(this.evaluators, workingIndexes, evaluatedValues));
        if (this.orderBy != null) {
            generatedTupleList.sort(this.orderBy);
        }
        return new LinkedList<Tuple>(generatedTupleList);
    }

    private boolean iterate(List<NamedEvaluator> evaluators, int[] indexes, Map<String, Object> evaluatedValues) {
        int offset = indexes.length - 1;
        while (offset >= 0) {
            Object evaluatedValue = evaluatedValues.get(evaluators.get(offset).getName());
            if (evaluatedValue instanceof Collection) {
                int currentIndexValue = indexes[offset];
                if (currentIndexValue < ((Collection)evaluatedValue).size() - 1) {
                    indexes[offset] = currentIndexValue + 1;
                    return true;
                }
                if (offset != 0) {
                    indexes[offset] = 0;
                }
            }
            --offset;
        }
        return false;
    }

    @Override
    public StreamComparator getStreamSort() {
        if (this.orderBy != null) {
            return this.stream.getStreamSort().append(this.orderBy);
        }
        return this.stream.getStreamSort();
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
        for (NamedEvaluator evaluator : this.evaluators) {
            evaluator.getEvaluator().setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
        this.generatedTuples = new LinkedList();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.generatedTuples.clear();
    }

    @Override
    public int getCost() {
        return 0;
    }

    class NamedEvaluator {
        private String name;
        private StreamEvaluator evaluator;

        public NamedEvaluator(String name, StreamEvaluator evaluator) {
            this.name = name;
            this.evaluator = evaluator;
        }

        public String getName() {
            return this.name;
        }

        public StreamEvaluator getEvaluator() {
            return this.evaluator;
        }
    }
}

