/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.JoinStream;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class BiJoinStream
extends JoinStream
implements Expressible {
    protected PushBackStream leftStream;
    protected PushBackStream rightStream;
    protected StreamComparator iterationComparator;
    protected StreamComparator leftStreamComparator;
    protected StreamComparator rightStreamComparator;

    public BiJoinStream(TupleStream leftStream, TupleStream rightStream, StreamEqualitor eq) throws IOException {
        super(eq, leftStream, rightStream, new TupleStream[0]);
        this.init();
    }

    public BiJoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        this.init();
    }

    private void init() throws IOException {
        this.validateTupleOrder();
        this.leftStream = this.getStream(0);
        this.rightStream = this.getStream(1);
        this.iterationComparator = this.createIterationComparator(this.eq, this.leftStream.getStreamSort());
        this.leftStreamComparator = this.createSideComparator(this.eq, this.leftStream.getStreamSort());
        this.rightStreamComparator = this.createSideComparator(this.eq, this.rightStream.getStreamSort());
    }

    @Override
    protected void validateTupleOrder() throws IOException {
        if (!this.isValidTupleOrder()) {
            throw new IOException("Invalid JoinStream - all incoming stream comparators (sort) must be a superset of this stream's equalitor.");
        }
    }

    private StreamComparator createIterationComparator(StreamEqualitor eq, StreamComparator comp) throws IOException {
        if (eq instanceof MultipleFieldEqualitor && comp instanceof MultipleFieldComparator) {
            StreamComparator[] compoundComps = new StreamComparator[((MultipleFieldEqualitor)eq).getEqs().length];
            int idx = 0;
            while (idx < compoundComps.length) {
                StreamEqualitor sourceEqualitor = ((MultipleFieldEqualitor)eq).getEqs()[idx];
                StreamComparator sourceComparator = ((MultipleFieldComparator)comp).getComps()[idx];
                if (!(sourceEqualitor instanceof FieldEqualitor) || !(sourceComparator instanceof FieldComparator)) {
                    throw new IOException("Failed to create an iteration comparator");
                }
                FieldEqualitor fieldEqualitor = (FieldEqualitor)sourceEqualitor;
                FieldComparator fieldComparator = (FieldComparator)sourceComparator;
                compoundComps[idx] = new FieldComparator(fieldEqualitor.getLeftFieldName(), fieldEqualitor.getRightFieldName(), fieldComparator.getOrder());
                ++idx;
            }
            return new MultipleFieldComparator(compoundComps);
        }
        if (comp instanceof MultipleFieldComparator) {
            StreamEqualitor sourceEqualitor = eq;
            StreamComparator sourceComparator = ((MultipleFieldComparator)comp).getComps()[0];
            if (sourceEqualitor instanceof FieldEqualitor && sourceComparator instanceof FieldComparator) {
                FieldEqualitor fieldEqualitor = (FieldEqualitor)sourceEqualitor;
                FieldComparator fieldComparator = (FieldComparator)sourceComparator;
                return new FieldComparator(fieldEqualitor.getLeftFieldName(), fieldEqualitor.getRightFieldName(), fieldComparator.getOrder());
            }
            throw new IOException("Failed to create an iteration comparator");
        }
        StreamEqualitor sourceEqualitor = eq;
        StreamComparator sourceComparator = comp;
        if (sourceEqualitor instanceof FieldEqualitor && sourceComparator instanceof FieldComparator) {
            FieldEqualitor fieldEqualitor = (FieldEqualitor)sourceEqualitor;
            FieldComparator fieldComparator = (FieldComparator)sourceComparator;
            return new FieldComparator(fieldEqualitor.getLeftFieldName(), fieldEqualitor.getRightFieldName(), fieldComparator.getOrder());
        }
        throw new IOException("Failed to create an iteration comparator");
    }

    private StreamComparator createSideComparator(StreamEqualitor eq, StreamComparator comp) throws IOException {
        if (eq instanceof MultipleFieldEqualitor && comp instanceof MultipleFieldComparator) {
            StreamComparator[] compoundComps = new StreamComparator[((MultipleFieldEqualitor)eq).getEqs().length];
            int idx = 0;
            while (idx < compoundComps.length) {
                StreamComparator sourceComparator = ((MultipleFieldComparator)comp).getComps()[idx];
                if (!(sourceComparator instanceof FieldComparator)) {
                    throw new IOException("Failed to create an side comparator");
                }
                FieldComparator fieldComparator = (FieldComparator)sourceComparator;
                compoundComps[idx] = new FieldComparator(fieldComparator.getLeftFieldName(), fieldComparator.getRightFieldName(), fieldComparator.getOrder());
                ++idx;
            }
            return new MultipleFieldComparator(compoundComps);
        }
        if (comp instanceof MultipleFieldComparator) {
            StreamComparator sourceComparator = ((MultipleFieldComparator)comp).getComps()[0];
            if (sourceComparator instanceof FieldComparator) {
                FieldComparator fieldComparator = (FieldComparator)sourceComparator;
                return new FieldComparator(fieldComparator.getLeftFieldName(), fieldComparator.getRightFieldName(), fieldComparator.getOrder());
            }
            throw new IOException("Failed to create an side comparator");
        }
        StreamComparator sourceComparator = comp;
        if (sourceComparator instanceof FieldComparator) {
            FieldComparator fieldComparator = (FieldComparator)sourceComparator;
            return new FieldComparator(fieldComparator.getLeftFieldName(), fieldComparator.getRightFieldName(), fieldComparator.getOrder());
        }
        throw new IOException("Failed to create an side comparator");
    }
}

