/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ReplaceWithFieldOperation
implements StreamOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    private boolean wasBuiltWithFieldName;
    private String originalFieldName;
    private Object originalValue;
    private String replacementFieldName;

    public ReplaceWithFieldOperation(String forField, StreamExpression expression, StreamFactory factory) throws IOException {
        if (2 == expression.getParameters().size()) {
            this.wasBuiltWithFieldName = false;
            this.originalFieldName = forField;
            this.originalValue = factory.constructPrimitiveObject(factory.getValueOperand(expression, 0));
        } else if (3 == expression.getParameters().size()) {
            this.wasBuiltWithFieldName = true;
            this.originalFieldName = factory.getValueOperand(expression, 0);
            this.originalValue = factory.constructPrimitiveObject(factory.getValueOperand(expression, 1));
        } else {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        StreamExpressionNamedParameter replacementParameter = factory.getNamedOperand(expression, "withField");
        if (replacementParameter == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a parameter named 'withField' but didn't find one.", expression));
        }
        if (!(replacementParameter.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting parameter named 'withField' to be a field name.", expression));
        }
        this.replacementFieldName = ((StreamExpressionValue)replacementParameter.getParameter()).getValue();
    }

    @Override
    public void operate(Tuple tuple) {
        if (this.matchesOriginal(tuple)) {
            this.replace(tuple);
        }
    }

    private boolean matchesOriginal(Tuple tuple) {
        Object value = tuple.get(this.originalFieldName);
        if (value == null) {
            return this.originalValue == null;
        }
        if (this.originalValue != null) {
            return this.originalValue.equals(value);
        }
        return false;
    }

    private void replace(Tuple tuple) {
        tuple.put(this.originalFieldName, tuple.get(this.replacementFieldName));
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.wasBuiltWithFieldName) {
            expression.addParameter(this.originalFieldName);
        }
        expression.addParameter(this.originalValue == null ? "null" : this.originalValue.toString());
        expression.addParameter(new StreamExpressionNamedParameter("withField", this.replacementFieldName));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

