/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.ReplaceWithFieldOperation;
import org.apache.solr.client.solrj.io.ops.ReplaceWithValueOperation;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ReplaceOperation
implements StreamOperation {
    private static final long serialVersionUID = 1L;
    private StreamOperation replacer;

    public ReplaceOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        this(null, expression, factory);
    }

    public ReplaceOperation(String forField, StreamExpression expression, StreamFactory factory) throws IOException {
        StreamExpressionNamedParameter withValue = factory.getNamedOperand(expression, "withValue");
        StreamExpressionNamedParameter withField = factory.getNamedOperand(expression, "withField");
        if (withValue != null && withField == null) {
            this.replacer = new ReplaceWithValueOperation(forField, expression, factory);
        } else if (withField != null && withValue == null) {
            this.replacer = new ReplaceWithFieldOperation(forField, expression, factory);
        } else {
            if (withValue != null && withField != null) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting either withValue or withField parameter but found both", expression));
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting withValue or withField parameter but found neither", expression));
        }
    }

    @Override
    public void operate(Tuple tuple) {
        this.replacer.operate(tuple);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return this.replacer.toExpression(factory);
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return this.replacer.toExplanation(factory);
    }
}

