/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.graph.Node;
import org.apache.solr.client.solrj.io.graph.Traversal;

class TraversalIterator
implements Iterator {
    private List<Map<String, Node>> graph;
    private List<String> collections;
    private List<String> fields;
    private Iterator<Iterator<Node>> graphIterator;
    private Iterator<Node> levelIterator;
    private Iterator<String> fieldIterator;
    private Iterator<String> collectionIterator;
    private Iterator<Integer> levelNumIterator;
    private String outField;
    private String outCollection;
    private int outLevel;
    private Traversal traversal;

    public TraversalIterator(Traversal traversal, Set<Traversal.Scatter> scatter) {
        String field;
        String collection;
        Map<String, Node> graphLevel;
        this.traversal = traversal;
        this.graph = traversal.getGraph();
        this.collections = traversal.getCollections();
        this.fields = traversal.getFields();
        ArrayList<String> outCollections = new ArrayList<String>();
        ArrayList<String> outFields = new ArrayList<String>();
        ArrayList<Integer> levelNums = new ArrayList<Integer>();
        ArrayList<Iterator<Node>> levelIterators = new ArrayList<Iterator<Node>>();
        if (scatter.contains((Object)Traversal.Scatter.BRANCHES) && this.graph.size() > 1) {
            int i = 0;
            while (i < this.graph.size() - 1) {
                graphLevel = this.graph.get(i);
                collection = this.collections.get(i);
                field = this.fields.get(i);
                outCollections.add(collection);
                outFields.add(field);
                levelNums.add(i);
                levelIterators.add(graphLevel.values().iterator());
                ++i;
            }
        }
        if (scatter.contains((Object)Traversal.Scatter.LEAVES)) {
            int leavesLevel = this.graph.size() > 1 ? this.graph.size() - 1 : 0;
            graphLevel = this.graph.get(leavesLevel);
            collection = this.collections.get(leavesLevel);
            field = this.fields.get(leavesLevel);
            levelNums.add(leavesLevel);
            outCollections.add(collection);
            outFields.add(field);
            levelIterators.add(graphLevel.values().iterator());
        }
        this.graphIterator = levelIterators.iterator();
        this.levelIterator = this.graphIterator.next();
        this.fieldIterator = outFields.iterator();
        this.collectionIterator = outCollections.iterator();
        this.levelNumIterator = levelNums.iterator();
        this.outField = this.fieldIterator.next();
        this.outCollection = this.collectionIterator.next();
        this.outLevel = this.levelNumIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.levelIterator.hasNext()) {
            return true;
        }
        if (this.graphIterator.hasNext()) {
            this.levelIterator = this.graphIterator.next();
            this.outField = this.fieldIterator.next();
            this.outCollection = this.collectionIterator.next();
            this.outLevel = this.levelNumIterator.next();
            return this.hasNext();
        }
        return false;
    }

    public Tuple next() {
        if (this.hasNext()) {
            Node node = this.levelIterator.next();
            return node.toTuple(this.outCollection, this.outField, this.outLevel, this.traversal);
        }
        return null;
    }
}

