/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.graph.Node;
import org.apache.solr.client.solrj.io.graph.TraversalIterator;

public class Traversal {
    private List<Map<String, Node>> graph = new ArrayList<Map<String, Node>>();
    private List<String> fields = new ArrayList<String>();
    private List<String> collections = new ArrayList<String>();
    private Set<Scatter> scatter = new HashSet<Scatter>();
    private Set<String> collectionSet = new HashSet<String>();
    private boolean trackTraversal;
    private int depth;

    public void addLevel(Map<String, Node> level, String collection, String field) {
        this.graph.add(level);
        this.collections.add(collection);
        this.collectionSet.add(collection);
        this.fields.add(field);
        ++this.depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean getTrackTraversal() {
        return this.trackTraversal;
    }

    public boolean visited(String nodeId, String ancestorId, Tuple tuple) {
        for (Map<String, Node> level : this.graph) {
            Node node = level.get(nodeId);
            if (node == null) continue;
            node.add(String.valueOf(this.depth) + "^" + ancestorId, tuple);
            return true;
        }
        return false;
    }

    public boolean isMultiCollection() {
        return this.collectionSet.size() > 1;
    }

    public List<Map<String, Node>> getGraph() {
        return this.graph;
    }

    public void setScatter(Set<Scatter> scatter) {
        this.scatter = scatter;
    }

    public Set<Scatter> getScatter() {
        return this.scatter;
    }

    public void setTrackTraversal(boolean trackTraversal) {
        this.trackTraversal = trackTraversal;
    }

    public List<String> getCollections() {
        return this.collections;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Iterator<Tuple> iterator() {
        return new TraversalIterator(this, this.scatter);
    }

    public static enum Scatter {
        BRANCHES,
        LEAVES;

    }
}

