/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TransposeEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public TransposeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            double[][] data = matrix.getData();
            Array2DRowRealMatrix amatrix = new Array2DRowRealMatrix(data, false);
            Array2DRowRealMatrix tmatrix = (Array2DRowRealMatrix)amatrix.transpose();
            Matrix newMatrix = new Matrix(tmatrix.getDataRef());
            newMatrix.setColumnLabels(matrix.getRowLabels());
            newMatrix.setRowLabels(matrix.getColumnLabels());
            return newMatrix;
        }
        throw new IOException("matrix parameter expected for transpose function");
    }
}

