/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SumColumnsEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public SumColumnsEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            double[][] data = matrix.getData();
            Array2DRowRealMatrix realMatrix = new Array2DRowRealMatrix(data, false);
            ArrayList<Double> sums = new ArrayList<Double>(data[0].length);
            int i = 0;
            while (i < data[0].length) {
                double sum = 0.0;
                double[] col = realMatrix.getColumn(i);
                int j = 0;
                while (j < col.length) {
                    sum += col[j];
                    ++j;
                }
                sums.add(sum);
                ++i;
            }
            return sums;
        }
        throw new IOException("Grand sum function only operates on a matrix");
    }
}

