/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class StandardDeviationEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public StandardDeviationEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            throw new IOException(String.format(Locale.ROOT, "Unable to find %s(...) because the value is null", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (value instanceof List) {
            List c = (List)value;
            double[] data = new double[c.size()];
            int i = 0;
            while (i < c.size()) {
                data[i] = ((Number)c.get(i)).doubleValue();
                ++i;
            }
            return Math.sqrt(StatUtils.variance((double[])data));
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to find %s(...) because the value is not a collection, instead a %s was found", this.constructingFactory.getFunctionName(this.getClass()), value.getClass().getSimpleName()));
    }
}

