/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SequenceEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public SequenceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting three values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (3 != values.length) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with 3 values but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values.length));
        }
        Number sizeNum = (Number)values[0];
        Number startNum = (Number)values[1];
        Number strideNum = (Number)values[2];
        ArrayList<Integer> sequence = new ArrayList<Integer>(sizeNum.intValue());
        int[] nArray = MathArrays.sequence((int)sizeNum.intValue(), (int)startNum.intValue(), (int)strideNum.intValue());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int number = nArray[n2];
            sequence.add(number);
            ++n2;
        }
        return sequence;
    }
}

