/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RowAtEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public RowAtEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        if (value1 instanceof Matrix) {
            Matrix matrix = (Matrix)value1;
            Number index = (Number)value2;
            double[] row = matrix.getData()[index.intValue()];
            ArrayList<Double> list = new ArrayList<Double>();
            double[] dArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                list.add(d);
                ++n2;
            }
            return list;
        }
        throw new IOException("The rowAt function expects a matrix as the first parameter");
    }
}

