/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class RecursiveNumericListEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    public RecursiveNumericListEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object normalizeInputType(Object value) throws StreamEvaluatorException {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.convertToNumber(innerValue)).collect(Collectors.toList());
        }
        throw new StreamEvaluatorException("Numeric list value expected but found type %s for value %s", value.getClass().getName(), value.toString());
    }

    private BigDecimal convertToNumber(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return null;
            }
            return new BigDecimal(value.toString());
        }
        if (value instanceof String) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        throw new StreamEvaluatorException("Numeric value expected but found type %s for value %s", value.getClass().getName(), value.toString());
    }
}

