/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.FieldValueEvaluator;
import org.apache.solr.client.solrj.io.eval.RawValueEvaluator;
import org.apache.solr.client.solrj.io.eval.SourceEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.eval.ValueWorker;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class RecursiveEvaluator
implements StreamEvaluator,
ValueWorker {
    protected static final long serialVersionUID = 1L;
    protected StreamContext streamContext;
    protected UUID nodeId = UUID.randomUUID();
    protected StreamFactory constructingFactory;
    protected List<StreamEvaluator> containedEvaluators = new ArrayList<StreamEvaluator>();

    public RecursiveEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        this(expression, factory, new ArrayList<String>());
    }

    protected Object normalizeInputType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof VectorFunction) {
            return value;
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return null;
            }
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Collection) {
            try {
                ArrayList<Double> vector = new ArrayList<Double>();
                boolean allDoubles = true;
                for (Object o : (Collection)value) {
                    if (o instanceof String) {
                        Double d = Double.parseDouble(o.toString());
                        vector.add(d);
                        continue;
                    }
                    allDoubles = false;
                    break;
                }
                if (allDoubles) {
                    return vector;
                }
            }
            catch (Exception vector) {
                // empty catch block
            }
            return ((Collection)value).stream().map(innerValue -> this.normalizeInputType(innerValue)).collect(Collectors.toList());
        }
        if (value.getClass().isArray()) {
            Stream<Object> stream = Stream.empty();
            if (value instanceof double[]) {
                stream = Arrays.stream((double[])value).boxed();
            } else if (value instanceof int[]) {
                stream = Arrays.stream((int[])value).boxed();
            } else if (value instanceof long[]) {
                stream = Arrays.stream((long[])value).boxed();
            } else if (value instanceof String[]) {
                stream = Arrays.stream((String[])value);
            }
            return stream.map(innerValue -> this.normalizeInputType(innerValue)).collect(Collectors.toList());
        }
        return value;
    }

    protected Object normalizeOutputType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof VectorFunction) {
            return value;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return bd.doubleValue();
        }
        if (value instanceof Long || value instanceof Integer) {
            return ((Number)value).longValue();
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.normalizeOutputType(innerValue)).collect(Collectors.toList());
        }
        if (value instanceof Tuple && value.getClass().getEnclosingClass() == null) {
            Tuple tuple = (Tuple)value;
            Tuple newTuple = new Tuple();
            for (Object o : tuple.getFields().keySet()) {
                Object v = tuple.get(o);
                newTuple.put(o, this.normalizeOutputType(v));
            }
            return newTuple;
        }
        return value;
    }

    public RecursiveEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        this.constructingFactory = factory;
        List<StreamExpressionParameter> parameters = factory.getOperandsOfType(expression, StreamExpressionParameter.class);
        for (StreamExpressionParameter parameter : parameters) {
            if (parameter instanceof StreamExpression) {
                StreamExpression streamExpression = (StreamExpression)parameter;
                if (factory.doesRepresentTypes(streamExpression, RecursiveEvaluator.class)) {
                    this.containedEvaluators.add(factory.constructEvaluator(streamExpression));
                    continue;
                }
                if (factory.doesRepresentTypes(streamExpression, SourceEvaluator.class)) {
                    this.containedEvaluators.add(factory.constructEvaluator(streamExpression));
                    continue;
                }
                this.containedEvaluators.add(new FieldValueEvaluator(streamExpression.toString()));
                continue;
            }
            if (!(parameter instanceof StreamExpressionValue) || ((StreamExpressionValue)parameter).getValue().length() == 0) continue;
            Object value = factory.constructPrimitiveObject(((StreamExpressionValue)parameter).getValue());
            if (value == null || value instanceof Boolean || value instanceof Number) {
                this.containedEvaluators.add(new RawValueEvaluator(value));
                continue;
            }
            if (!(value instanceof String)) continue;
            this.containedEvaluators.add(new FieldValueEvaluator((String)value));
        }
        Set namedParameters = factory.getNamedOperands(expression).stream().map(param -> param.getName()).collect(Collectors.toSet());
        long ignorableCount = ignoredNamedParameters.stream().filter(name -> namedParameters.contains(name)).count();
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        try {
            List<Object> containedResults = this.recursivelyEvaluate(tuple);
            return this.normalizeOutputType(this.doWork(containedResults.toArray()));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public List<Object> recursivelyEvaluate(Tuple tuple) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            for (StreamEvaluator containedEvaluator : this.containedEvaluators) {
                results.add(this.normalizeInputType(containedEvaluator.evaluate(tuple)));
            }
        }
        catch (StreamEvaluatorException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to evaluate expression %s - %s", this.toExpression(this.constructingFactory), e.getMessage()), e);
        }
        return results;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (StreamEvaluator evaluator : this.containedEvaluators) {
            expression.addParameter(evaluator.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        for (StreamEvaluator containedEvaluator : this.containedEvaluators) {
            containedEvaluator.setStreamContext(context);
        }
    }

    @Override
    public StreamContext getStreamContext() {
        return this.streamContext;
    }
}

