/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class RecursiveBooleanEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    protected abstract Checker constructChecker(Object var1) throws IOException;

    public RecursiveBooleanEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object normalizeInputType(Object value) throws StreamEvaluatorException {
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length < 2) {
            String message = null;
            message = 1 == values.length ? String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 0 were provided", this.constructingFactory.getFunctionName(this.getClass()));
            throw new IOException(message);
        }
        Checker checker = this.constructChecker(values[0]);
        if (Arrays.stream(values).anyMatch(result -> result == null)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (Arrays.stream(values).anyMatch(result -> !checker.isCorrectType(result))) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) of differing types [%s]", this.constructingFactory.getFunctionName(this.getClass()), Arrays.stream(values).map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        int idx = 1;
        while (idx < values.length) {
            if (!checker.test(values[idx - 1], values[idx])) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public static interface BooleanChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof Boolean;
        }
    }

    public static interface Checker {
        default public boolean isNullAllowed() {
            return false;
        }

        public boolean isCorrectType(Object var1);

        public boolean test(Object var1, Object var2);
    }

    public static interface NullChecker
    extends Checker {
        @Override
        default public boolean isNullAllowed() {
            return true;
        }

        @Override
        default public boolean isCorrectType(Object value) {
            return true;
        }

        @Override
        default public boolean test(Object left, Object right) {
            return left == null && right == null;
        }
    }

    public static interface NumberChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof Number;
        }
    }

    public static interface StringChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof String;
        }
    }
}

