/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PolyFitDerivativeEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public PolyFitDerivativeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length > 3) {
            throw new IOException("polyfitDerivative function takes a maximum of 3 arguments.");
        }
        Object first = objects[0];
        double[] x = null;
        double[] y = null;
        int degree = 3;
        if (objects.length == 1) {
            y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            x = new double[y.length];
            int i = 0;
            while (i < y.length) {
                x[i] = i;
                ++i;
            }
        } else if (objects.length == 3) {
            Object second = objects[1];
            x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            degree = ((Number)objects[2]).intValue();
        } else if (objects.length == 2) {
            if (objects[1] instanceof List) {
                Object second = objects[1];
                x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
                y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            } else {
                y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
                x = new double[y.length];
                int i = 0;
                while (i < y.length) {
                    x[i] = i;
                    ++i;
                }
                degree = ((Number)objects[1]).intValue();
            }
        }
        PolynomialCurveFitter curveFitter = PolynomialCurveFitter.create((int)degree);
        WeightedObservedPoints points = new WeightedObservedPoints();
        int i = 0;
        while (i < x.length) {
            points.add(x[i], y[i]);
            ++i;
        }
        double[] coef = curveFitter.fit((Collection)points.toList());
        PolynomialFunction pf = new PolynomialFunction(coef);
        UnivariateFunction univariateFunction = pf.derivative();
        ArrayList<Double> list = new ArrayList<Double>();
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double xvalue = dArray[n2];
            double yvalue = univariateFunction.value(xvalue);
            list.add(yvalue);
            ++n2;
        }
        return list;
    }
}

