/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PivotEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public PivotEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (4 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 4 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length != 4) {
            throw new IOException("The pivot function requires four parameters.");
        }
        Object value1 = values[0];
        Object value2 = values[1];
        Object value3 = values[2];
        Object value4 = values[3];
        if (value1 instanceof List) {
            List tuples = (List)value1;
            String x = (String)value2;
            x = x.replace("\"", "");
            String y = (String)value3;
            y = y.replace("\"", "");
            String vlabel = (String)value4;
            vlabel = vlabel.replace("\"", "");
            TreeSet<String> xset = new TreeSet<String>();
            TreeSet<String> yset = new TreeSet<String>();
            int i = 0;
            while (i < tuples.size()) {
                Tuple tuple = (Tuple)tuples.get(i);
                xset.add(tuple.getString(x));
                yset.add(tuple.getString(y));
                ++i;
            }
            double[][] data = new double[xset.size()][yset.size()];
            ArrayList<String> xlabels = new ArrayList<String>(xset.size());
            HashMap<String, Integer> xindexes = new HashMap<String, Integer>();
            int xindex = 0;
            for (String xlabel : xset) {
                xlabels.add(xlabel);
                xindexes.put(xlabel, xindex);
                ++xindex;
            }
            ArrayList<String> ylabels = new ArrayList<String>(yset.size());
            HashMap<String, Integer> yindexes = new HashMap<String, Integer>();
            int yindex = 0;
            for (String ylabel : yset) {
                ylabels.add(ylabel);
                yindexes.put(ylabel, yindex);
                ++yindex;
            }
            for (Tuple tuple : tuples) {
                double val;
                String xlabel = tuple.getString(x);
                String ylabel = tuple.getString(y);
                int xi = (Integer)xindexes.get(xlabel);
                int yi = (Integer)yindexes.get(ylabel);
                data[xi][yi] = val = tuple.getDouble(vlabel).doubleValue();
            }
            Matrix matrix = new Matrix(data);
            matrix.setRowLabels(xlabels);
            matrix.setColumnLabels(ylabels);
            return matrix;
        }
        throw new IOException("The getValue function expects a list of tuples as the first parameter");
    }
}

