/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PercentileEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PercentileEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (first == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (second == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a List", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (second instanceof Number) {
            Percentile percentile = new Percentile();
            percentile.setData(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            return percentile.evaluate(((Number)second).doubleValue());
        }
        if (second instanceof List) {
            Percentile percentile = new Percentile();
            percentile.setData(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            List values = (List)second;
            ArrayList<Double> percentiles = new ArrayList<Double>();
            for (Number value2 : values) {
                percentiles.add(percentile.evaluate(value2.doubleValue()));
            }
            return percentiles;
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a number or a numeric array", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
    }
}

