/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PairSortEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PairSortEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (first == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (second == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        List l1 = (List)first;
        List l2 = (List)second;
        if (l2.size() != l1.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - first list (%d) has a different size than the second list (%d)", this.toExpression(this.constructingFactory), l1.size(), l2.size()));
        }
        ArrayList<double[]> pairs = new ArrayList<double[]>();
        int idx = 0;
        while (idx < l1.size()) {
            double[] pair = new double[]{((Number)l1.get(idx)).doubleValue(), ((Number)l2.get(idx)).doubleValue()};
            pairs.add(pair);
            ++idx;
        }
        Collections.sort(pairs, new PairComp());
        double[][] data = new double[2][pairs.size()];
        int i = 0;
        while (i < pairs.size()) {
            data[0][i] = ((double[])pairs.get(i))[0];
            data[1][i] = ((double[])pairs.get(i))[1];
            ++i;
        }
        return new Matrix(data);
    }

    private class PairComp
    implements Comparator<double[]> {
        private PairComp() {
        }

        @Override
        public int compare(double[] a, double[] b) {
            if (a[0] > b[0]) {
                return 1;
            }
            if (a[0] < b[0]) {
                return -1;
            }
            if (a[1] > b[1]) {
                return 1;
            }
            if (a[1] < b[1]) {
                return -1;
            }
            return 0;
        }
    }
}

