/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class NaturalEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public NaturalEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) {
        int natural = ((Number)value).intValue();
        ArrayList<Integer> naturals = new ArrayList<Integer>();
        int i = 0;
        while (i < natural) {
            naturals.add(i);
            ++i;
        }
        return naturals;
    }
}

