/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.MultiKMeansPlusPlusClusterer;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultiKmeansEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private int maxIterations = 1000;

    public MultiKmeansEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("maxIterations")) {
                this.maxIterations = Integer.parseInt(namedParam.getParameter().toString().trim());
                continue;
            }
            throw new IOException("Unexpected named parameter:" + namedParam.getName());
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length != 3) {
            throw new IOException("The multiKmeans function expects three parameters; a matrix to cluster, k and number of trials.");
        }
        Object value1 = values[0];
        Object value2 = values[1];
        Object value3 = values[2];
        Matrix matrix = null;
        int k = 0;
        int trials = 0;
        if (!(value1 instanceof Matrix)) {
            throw new IOException("The first parameter for multiKmeans should be the observation matrix.");
        }
        matrix = (Matrix)value1;
        if (!(value2 instanceof Number)) {
            throw new IOException("The second parameter for multiKmeans should be k.");
        }
        k = ((Number)value2).intValue();
        if (!(value3 instanceof Number)) {
            throw new IOException("The third parameter for multiKmeans should be trials.");
        }
        trials = ((Number)value3).intValue();
        KMeansPlusPlusClusterer kmeans = new KMeansPlusPlusClusterer(k, this.maxIterations);
        MultiKMeansPlusPlusClusterer multiKmeans = new MultiKMeansPlusPlusClusterer(kmeans, trials);
        ArrayList<KmeansEvaluator.ClusterPoint> points = new ArrayList<KmeansEvaluator.ClusterPoint>();
        double[][] data = matrix.getData();
        List<String> ids = matrix.getRowLabels();
        int i = 0;
        while (i < data.length) {
            double[] vec = data[i];
            points.add(new KmeansEvaluator.ClusterPoint(ids.get(i), vec));
            ++i;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("k", k);
        fields.put("trials", trials);
        fields.put("distance", "euclidean");
        fields.put("maxIterations", this.maxIterations);
        return new KmeansEvaluator.ClusterTuple(fields, multiKmeans.cluster(points), matrix.getColumnLabels());
    }
}

