/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MonteCarloEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;
    private Map variables = new LinkedHashMap();

    public MonteCarloEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        Object echo = null;
        boolean echoAll = false;
        for (StreamExpressionParameter streamExpressionParameter : namedParams) {
            String name = ((StreamExpressionNamedParameter)streamExpressionParameter).getName();
            StreamExpressionParameter param = ((StreamExpressionNamedParameter)streamExpressionParameter).getParameter();
            if (factory.isEvaluator((StreamExpression)param)) {
                StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
                this.variables.put(name, evaluator);
                continue;
            }
            TupleStream tupleStream = factory.constructStream((StreamExpression)param);
            this.variables.put(name, tupleStream);
        }
        this.init();
    }

    public MonteCarloEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        super(expression, factory, ignoredNamedParameters);
        this.init();
    }

    private void init() throws IOException {
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 parameters but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        }
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        try {
            StreamEvaluator function = (StreamEvaluator)this.containedEvaluators.get(0);
            StreamEvaluator iterationsEvaluator = (StreamEvaluator)this.containedEvaluators.get(1);
            Number itNum = (Number)iterationsEvaluator.evaluate(tuple);
            int it = itNum.intValue();
            ArrayList<Number> results = new ArrayList<Number>();
            int i = 0;
            while (i < it) {
                this.populateVariables(tuple);
                Number result = (Number)function.evaluate(tuple);
                results.add(result);
                ++i;
            }
            return results;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        throw new IOException("This call should never occur");
    }

    private void populateVariables(Tuple contextTuple) throws IOException {
        Set entries = this.variables.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object o = entry.getValue();
            if (o instanceof TupleStream) {
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                tStream.setStreamContext(this.streamContext);
                try (TupleStream tStream = (TupleStream)o;){
                    tStream.open();
                    while (true) {
                        Tuple tuple = tStream.read();
                        if (tuple.EOF) break;
                        tuples.add(tuple);
                    }
                    contextTuple.put(name, tuples);
                    continue;
                }
            }
            StreamEvaluator evaluator = (StreamEvaluator)o;
            Object eo = evaluator.evaluate(contextTuple);
            contextTuple.put(name, eo);
        }
    }
}

