/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MinMaxScaleEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MinMaxScaleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values == null) {
            return null;
        }
        double min = 0.0;
        double max = 1.0;
        if (values.length == 3) {
            min = ((Number)values[1]).doubleValue();
            max = ((Number)values[2]).doubleValue();
        }
        if (values[0] instanceof Matrix) {
            Matrix matrix = (Matrix)values[0];
            double[][] data = matrix.getData();
            double[][] scaled = new double[data.length][];
            int i = 0;
            while (i < scaled.length) {
                double[] row = data[i];
                scaled[i] = MinMaxScaleEvaluator.scale(row, min, max);
                ++i;
            }
            return new Matrix(scaled);
        }
        if (values[0] instanceof List) {
            List vec = (List)values[0];
            double[] data = new double[vec.size()];
            int i = 0;
            while (i < vec.size()) {
                data[i] = ((Number)vec.get(i)).doubleValue();
                ++i;
            }
            data = MinMaxScaleEvaluator.scale(data, min, max);
            ArrayList<Double> scaled = new ArrayList<Double>(data.length);
            double[] dArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                scaled.add(d);
                ++n2;
            }
            return scaled;
        }
        throw new IOException();
    }

    public static double[] scale(double[] values, double min, double max) {
        double localMin = Double.MAX_VALUE;
        double localMax = Double.MIN_VALUE;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > localMax) {
                localMax = d;
            }
            if (d < localMin) {
                localMin = d;
            }
            ++n2;
        }
        double[] scaled = new double[values.length];
        int i = 0;
        while (i < scaled.length) {
            double s;
            double x = values[i];
            scaled[i] = s = (x - localMin) / (localMax - localMin);
            ++i;
        }
        if (min != 0.0 || max != 1.0) {
            double scale = max - min;
            int i2 = 0;
            while (i2 < scaled.length) {
                double d = scaled[i2];
                scaled[i2] = scale * d + min;
                ++i2;
            }
        }
        return scaled;
    }
}

