/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MemsetEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;
    private TupleStream in;
    private String[] cols;
    private String[] vars;
    private int size = -1;

    public MemsetEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter colsExpression = factory.getNamedOperand(expression, "cols");
        StreamExpressionNamedParameter varsExpression = factory.getNamedOperand(expression, "vars");
        StreamExpressionNamedParameter sizeExpression = factory.getNamedOperand(expression, "size");
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (colsExpression == null || !(colsExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'cols' parameter listing fields to sort over but didn't find one", expression));
        }
        if (varsExpression == null || !(varsExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'vars' parameter listing fields to sort over but didn't find one", expression));
        }
        if (sizeExpression != null) {
            StreamExpressionValue sizeExpressionValue = (StreamExpressionValue)sizeExpression.getParameter();
            String sizeString = sizeExpressionValue.getValue();
            this.size = Integer.parseInt(sizeString);
        }
        this.in = factory.constructStream(streamExpressions.get(0));
        StreamExpressionValue colsExpressionValue = (StreamExpressionValue)colsExpression.getParameter();
        StreamExpressionValue varsExpressionValue = (StreamExpressionValue)varsExpression.getParameter();
        String colsString = colsExpressionValue.getValue();
        String varsString = varsExpressionValue.getValue();
        this.vars = varsString.split(",");
        this.cols = colsString.split(",");
        if (this.cols.length != this.vars.length) {
            throw new IOException("The cols and vars lists must be the same size");
        }
        int i = 0;
        while (i < this.cols.length) {
            this.cols[i] = this.cols[i].trim();
            this.vars[i] = this.vars[i].trim();
            ++i;
        }
    }

    public MemsetEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        super(expression, factory, ignoredNamedParameters);
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        try {
            this.in.setStreamContext(this.streamContext);
            this.in.open();
            HashMap arrays = new HashMap();
            String[] stringArray = this.vars;
            int n = this.vars.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (this.size > -1) {
                    arrays.put(var, new ArrayList(this.size));
                } else {
                    arrays.put(var, new ArrayList());
                }
                ++n2;
            }
            int count = 0;
            while (true) {
                Tuple t = this.in.read();
                if (t.EOF) break;
                if (this.size == -1 || count < this.size) {
                    int i = 0;
                    while (i < this.cols.length) {
                        String col = this.cols[i];
                        String var = this.vars[i];
                        List array = (List)arrays.get(var);
                        Number number = (Number)t.get(col);
                        array.add(number);
                        ++i;
                    }
                }
                ++count;
            }
            HashMap hashMap = arrays;
            return hashMap;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        throw new IOException("This call should never occur");
    }
}

