/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericListEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MatrixEvaluator
extends RecursiveNumericListEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MatrixEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        double[][] data = new double[values.length][];
        int i = 0;
        while (i < values.length) {
            List vec = (List)values[i];
            double[] array = new double[vec.size()];
            int j = 0;
            while (j < array.length) {
                array[j] = ((Number)vec.get(j)).doubleValue();
                ++j;
            }
            data[i] = array;
            ++i;
        }
        return new Matrix(data);
    }
}

