/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LengthEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public LengthEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            throw new IOException(String.format(Locale.ROOT, "Unable to find %s(...) because the value is null", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to find %s(...) because the value is not a collection, instead a %s was found", this.constructingFactory.getFunctionName(this.getClass()), value.getClass().getSimpleName()));
    }
}

