/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LeftShiftEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public LeftShiftEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        if (value1 instanceof List && value2 instanceof Number) {
            List actual = (List)value1;
            int val = ((Number)value2).intValue();
            ArrayList shifted = new ArrayList();
            int i = val;
            while (i < actual.size()) {
                shifted.add(actual.get(i));
                ++i;
            }
            return shifted;
        }
        throw new IOException("The ltrim function takes two parameters: an array and number to trim it by");
    }
}

