/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LatLonVectorsEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private String field;

    public LatLonVectorsEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("field")) {
                this.field = namedParam.getParameter().toString();
                continue;
            }
            throw new IOException("Unexpected named parameter:" + namedParam.getName());
        }
        if (this.field == null) {
            throw new IOException("The named parameter \"field\" must be set for the latlonVectors function.");
        }
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length == 1) {
            if (!(objects[0] instanceof List)) {
                throw new IOException("The latlonVectors function expects a list of Tuples as a parameter.");
            }
            List list = (List)objects[0];
            if (list.size() > 0) {
                Object o = list.get(0);
                if (!(o instanceof Tuple)) {
                    throw new IOException("The latlonVectors function expects a list of Tuples as a parameter.");
                }
            } else {
                throw new IOException("Empty list was passed as a parameter to termVectors function.");
            }
            List tuples = (List)objects[0];
            double[][] locationVectors = new double[tuples.size()][2];
            ArrayList<String> features = new ArrayList<String>();
            features.add("lat");
            features.add("lon");
            ArrayList<String> rowLabels = new ArrayList<String>();
            int i = 0;
            while (i < tuples.size()) {
                Tuple tuple = (Tuple)tuples.get(i);
                String value = tuple.getString(this.field);
                String[] latLong = null;
                latLong = value.contains(",") ? value.split(",") : value.split(" ");
                locationVectors[i][0] = Double.parseDouble(latLong[0].trim());
                locationVectors[i][1] = Double.parseDouble(latLong[1].trim());
                if (tuple.get("id") != null) {
                    rowLabels.add(tuple.get("id").toString());
                }
                ++i;
            }
            Matrix matrix = new Matrix(locationVectors);
            matrix.setColumnLabels(features);
            matrix.setRowLabels(rowLabels);
            return matrix;
        }
        throw new IOException("The latlonVectors function takes a single positional parameter.");
    }
}

