/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.RombergIntegrator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class IntegrateEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public IntegrateEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length > 3) {
            throw new IOException("The integrate function requires at most 3 parameters");
        }
        if (!(values[0] instanceof VectorFunction)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a FunctionVector", this.toExpression(this.constructingFactory), values[0].getClass().getSimpleName()));
        }
        VectorFunction vectorFunction = (VectorFunction)values[0];
        if (!(vectorFunction.getFunction() instanceof UnivariateFunction)) {
            throw new IOException("Cannot evaluate integral from parameter.");
        }
        UnivariateFunction func = (UnivariateFunction)vectorFunction.getFunction();
        if (values.length == 3) {
            Number min = null;
            Number max = null;
            if (!(values[1] instanceof Number)) {
                throw new IOException("The second parameter of the integrate function must be a number");
            }
            min = (Number)values[1];
            if (!(values[2] instanceof Number)) {
                throw new IOException("The third parameter of the integrate function must be a number");
            }
            max = (Number)values[2];
            RombergIntegrator rombergIntegrator = new RombergIntegrator();
            return rombergIntegrator.integrate(5000, func, min.doubleValue(), max.doubleValue());
        }
        RombergIntegrator integrator = new RombergIntegrator();
        double[] x = (double[])vectorFunction.getFromContext("x");
        double[] y = (double[])vectorFunction.getFromContext("y");
        ArrayList<Number> out = new ArrayList<Number>();
        out.add(0);
        int i = 1;
        while (i < x.length) {
            out.add(integrator.integrate(5000, func, x[0], x[i]));
            ++i;
        }
        return out;
    }
}

