/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetCentroidsEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public GetCentroidsEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof KmeansEvaluator.ClusterTuple)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a clustering result", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        KmeansEvaluator.ClusterTuple clusterTuple = (KmeansEvaluator.ClusterTuple)value;
        List<CentroidCluster<KmeansEvaluator.ClusterPoint>> clusters = clusterTuple.getClusters();
        double[][] data = new double[clusters.size()][];
        int i = 0;
        while (i < clusters.size()) {
            CentroidCluster<KmeansEvaluator.ClusterPoint> centroidCluster = clusters.get(i);
            Clusterable clusterable = centroidCluster.getCenter();
            data[i] = clusterable.getPoint();
            ++i;
        }
        Matrix centroids = new Matrix(data);
        centroids.setColumnLabels(clusterTuple.getColumnLabels());
        return centroids;
    }
}

