/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.apache.commons.math3.fitting.GaussianCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GaussFitEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public GaussFitEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length >= 3) {
            throw new IOException("gaussfit function takes a maximum of 2 arguments.");
        }
        Object first = objects[0];
        double[] x = null;
        double[] y = null;
        if (objects.length == 1) {
            y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            x = new double[y.length];
            int i = 0;
            while (i < y.length) {
                x[i] = i;
                ++i;
            }
        } else if (objects.length == 2) {
            Object second = objects[1];
            x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        }
        GaussianCurveFitter curveFitter = GaussianCurveFitter.create();
        WeightedObservedPoints points = new WeightedObservedPoints();
        int i = 0;
        while (i < x.length) {
            points.add(x[i], y[i]);
            ++i;
        }
        List pointList = points.toList();
        double[] guess = new GaussianCurveFitter.ParameterGuesser((Collection)pointList).guess();
        curveFitter = curveFitter.withStartPoint(guess);
        double[] coef = curveFitter.fit((Collection)pointList);
        Gaussian gaussian = new Gaussian(coef[0], coef[1], coef[2]);
        ArrayList<Number> list = new ArrayList<Number>();
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double xvalue = dArray[n2];
            double yvalue = gaussian.value(xvalue);
            list.add(yvalue);
            ++n2;
        }
        return new VectorFunction((Object)gaussian, list);
    }
}

