/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.Frequency;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FrequencyTableEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public FrequencyTableEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (Arrays.stream(values).anyMatch(item -> item == null)) {
            return null;
        }
        if (values.length != 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        }
        List<Object> sourceValues = values[0] instanceof List ? (List<Object>)values[0] : Arrays.asList(values[0]);
        Frequency frequency = new Frequency();
        for (Object o : sourceValues) {
            Number number = (Number)o;
            frequency.addValue(number.longValue());
        }
        ArrayList<Tuple> histogramBins = new ArrayList<Tuple>();
        Iterator iterator = frequency.valuesIterator();
        while (iterator.hasNext()) {
            Long value = (Long)iterator.next();
            Tuple tuple = new Tuple();
            tuple.put("value", (long)value);
            tuple.put("count", frequency.getCount((Comparable)value));
            tuple.put("cumFreq", frequency.getCumFreq((Comparable)value));
            tuple.put("cumPct", frequency.getCumPct((Comparable)value));
            tuple.put("pct", frequency.getPct((Comparable)value));
            histogramBins.add(tuple);
        }
        return histogramBins;
    }
}

