/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ExclusiveOrEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ExclusiveOrEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length < 2) {
            String message = null;
            message = 1 == values.length ? String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 0 were provided", this.constructingFactory.getFunctionName(this.getClass()));
            throw new IOException(message);
        }
        RecursiveBooleanEvaluator.Checker checker = this.constructChecker(values[0]);
        if (Arrays.stream(values).anyMatch(result -> result == null)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (Arrays.stream(values).anyMatch(result -> !checker.isCorrectType(result))) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) of differing types [%s]", this.constructingFactory.getFunctionName(this.getClass()), Arrays.stream(values).map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        if (1L == Arrays.stream(values).filter(result -> (Boolean)result).count()) {
            return true;
        }
        return false;
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object value) throws IOException {
        return new RecursiveBooleanEvaluator.BooleanChecker(){

            @Override
            public boolean test(Object left, Object right) {
                return false;
            }
        };
    }
}

