/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EBEAddEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public EBEAddEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (first == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (second == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (first instanceof List && second instanceof List) {
            double[] result = MathArrays.ebeAdd((double[])((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), (double[])((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            ArrayList<Double> numbers = new ArrayList<Double>();
            double[] dArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                numbers.add(d);
                ++n2;
            }
            return numbers;
        }
        if (first instanceof Matrix && second instanceof Matrix) {
            double[][] data1 = ((Matrix)first).getData();
            double[][] data2 = ((Matrix)second).getData();
            Array2DRowRealMatrix matrix1 = new Array2DRowRealMatrix(data1, false);
            Array2DRowRealMatrix matrix2 = new Array2DRowRealMatrix(data2, false);
            Array2DRowRealMatrix matrix3 = matrix1.add(matrix2);
            return new Matrix(matrix3.getDataRef());
        }
        throw new IOException("Parameters for ebeAdd must either be two numeric arrays or two matrices. ");
    }
}

