/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DotProductEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public DotProductEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (first == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (second == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        ArrayRealVector v = new ArrayRealVector(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        ArrayRealVector v2 = new ArrayRealVector(((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        return v.dotProduct((RealVector)v2);
    }
}

