/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DivideEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public DivideEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (2 != values.length) {
            String message = null;
            message = 1 == values.length ? String.format(Locale.ROOT, "%s(...) only works with a 2 values (numerator,denominator) but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with a 2 values (numerator,denominator) but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values.length);
            throw new IOException(message);
        }
        return this.doWork(values[0], values[1]);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (first == null) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a null numerator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (second == null) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a null denominator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        BigDecimal numerator = (BigDecimal)first;
        BigDecimal denominator = (BigDecimal)second;
        if (denominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a 0 denominator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        return numerator.divide(denominator, MathContext.DECIMAL64);
    }
}

